DELIMITER $$
DROP PROCEDURE IF EXISTS V20210804144743__Create_ProgramBatchCourseStudentDetailView $$
CREATE PROCEDURE V20210804144743__Create_ProgramBatchCourseStudentDetailView()
BEGIN

	/** view 1 program_intake_class_details_view Start */
DROP VIEW IF EXISTS program_intake_class_details_view; 
IF NOT EXISTS ((SELECT * FROM information_schema.views WHERE table_schema=DATABASE() AND table_name='program_intake_class_details_view')) THEN 
CREATE 
    ALGORITHM = UNDEFINED 
    DEFINER = `ss_root`@`%` 
    SQL SECURITY DEFINER
VIEW `program_intake_class_details_view` AS
select DISTINCT 
`al`.`id` as `Academy_Location_Id`,
`al`.`academyName` as `Academy_Name`,
`al`.`locationName` as `Location_Name`,
`p`.`programNameToBePrint` as `Program_Name`,
`b`.`printName` as `Batch_Name`,
`sec`.`sectionCode` as `Section_Name`,
`u`.`code` as `Faculty_Code`,
`u`.`printName` as `Faculty_Name`,
`sec`.`maxCapacity` as `Class_Capacity`
 from `sections` `sec` join `prog_batch_period_config` `per` on `sec`.`periodId`=`per`.`id` 
join `batches` `b` on `per`.`programBatchId`=`b`.`id` join `programs` `p` on `b`.`programId`=`p`.`id`
join `academy_location` `al` on `p`.`academyLocationId`=`al`.`id` 
join `users` `u` on `u`.`id`=`sec`.`facultyId`
join `academic_term` `ac` on `per`.`academicTermId`=`ac`.`id`
where `ac`.`whetherCurrentAcademicTerm`=true;

END IF; 
/** view 1- program_intake_class_details_view End */

/** view 2- program_course_faculty_details_view Start */
DROP VIEW IF EXISTS program_course_faculty_details_view; 
IF NOT EXISTS ((SELECT * FROM information_schema.views WHERE table_schema=DATABASE() AND table_name='program_course_faculty_details_view')) THEN 
CREATE 
    ALGORITHM = UNDEFINED 
    DEFINER = `ss_root`@`%` 
    SQL SECURITY DEFINER
VIEW `program_course_faculty_details_view` AS
select DISTINCT 
`al`.`id` as `Academy_Location_Id`,
`al`.`academyName` as `Academy_Name`,
`al`.`locationName` as `Location_Name`,
`p`.`programNameToBePrint` as `Program_Name`,
`b`.`printName` as `Batch_Name`,
`sec`.`sectionCode` as `Section_Code`,
`co`.`courseCode` as `Subject_Code`,
`co`.`courseName` as `Subject_Name`,
`cv`.`courseVariantDescription` as `Subject_Variant_Class`,
`sec`.`maxCapacity` as `Subject_Class_Capacity`,
`res`.`code` as `Class_Room_Code`,
`res`.`resourceName` as `Class_Room_Name`,
`u`.`code` as `Faculty_Code`,
`u`.`firstName` as `Faculty_First_Name`,
`u`.`middleName` as `Faculty_Middle_Name`,
`u`.`lastName` as `Faculty_Last_Name`,
`u`.`printName` as `Faculty_Name`
 from `program_batch_course_param` `pbcp` 
join `prog_batch_course_faculty` `pbcf` on `pbcf`.`progBatchCourseParamId`=`pbcp`.`id`
join `users` `u` on `u`.`id`=`pbcf`.`facultyId`
left join `courses` `co` on `co`.`id`=`pbcp`.`courseId`
left join `course_variants` `cv` on `cv`.`id`=`pbcp`.`courseVarientId`
left join `sections` `sec` on `sec`.`id`=`pbcp`.`sectionId`
join `prog_batch_period_config` `per` on `pbcp`.`progBatchPeriodConfigId`=`per`.`id` 
join `batches` `b` on `per`.`programBatchId`=`b`.`id` join `programs` `p` on `b`.`programId`=`p`.`id`
join `academy_location` `al` on `p`.`academyLocationId`=`al`.`id` 
join `academic_term` `ac` on `per`.`academicTermId`=`ac`.`id`
join `resources` `res` on `res`.`id`=`sec`.`roomId`
where `ac`.`whetherCurrentAcademicTerm`=true;

END IF; 

/** view 2- program_course_faculty_details_view End */


/** view 3- class_room_details_view Start */
DROP VIEW IF EXISTS class_room_details_view; 
IF NOT EXISTS ((SELECT * FROM information_schema.views WHERE table_schema=DATABASE() AND table_name='class_room_details_view')) THEN 
CREATE 
    ALGORITHM = UNDEFINED 
    DEFINER = `ss_root`@`%` 
    SQL SECURITY DEFINER
VIEW `class_room_details_view` AS
select DISTINCT
`al`.`id` as `Academy_Location_Id`,
`al`.`academyName` as `Academy_Name`,
`al`.`locationName` as `Location_Name`,
`res`.`code` as `Class_Room_Code`,
`res`.`resourceName` as `Class_Room_Name`,
`rbp`.`capacity` as `Class_Room_Capacity`
 from `resources` `res` join `resource_booking_purposes` `rbp` on `rbp`.`resourceId`=`res`.`id` 
join `booking_purposes` `bp` on `rbp`.`bookingPurposeId`=`bp`.`id` 
left join `resource_academy_locations` `rac` on `rac`.`resourceId`=`res`.`id` 
left join `academy_location` `al` on `al`.`id`=`rac`.`academyLocationId`
where `bp`.`value`="Academic" and `res`.`resourceTypeId`=5 and `res`.`whetherDeleted`=false;

END IF; 
/** view 3- class_room_details_view End */

/** view 4- student_course_enrollment_details_view Start */
DROP VIEW IF EXISTS student_course_enrollment_details_view; 
IF NOT EXISTS ((SELECT * FROM information_schema.views WHERE table_schema=DATABASE() AND table_name='student_course_enrollment_details_view')) THEN 
CREATE 
    ALGORITHM = UNDEFINED 
    DEFINER = `ss_root`@`%` 
    SQL SECURITY DEFINER
VIEW `student_course_enrollment_details_view` AS
select DISTINCT 
`al`.`id` as `Academy_Location_Id`,
`al`.`academyName` as `Academy_Name`,
`al`.`locationName` as `Location_Name`,
`u`.`code` as `Student_Id`,
`ad`.`code` as `Admission_Id`,
`u`.`printName` as `Student_Name`,
`u`.`firstName` as `Student_First_Name`,
`u`.`middleName` as `Student_Middle_Name`,
`u`.`lastName` as `Student_Last_Name`,
`p`.`programNameToBePrint` as `Program_Name`,
`b`.`printName` as `Batch_name`,
`co`.`courseCode` as `Subject_Code`,
`co`.`courseName` as `Subject_Name`,
`cv`.`courseVariantDescription` as `Subject_Variant_Class`
 from `student_course_enrollment` `sce`
 join `admission` `ad` on `ad`.`id`=`sce`.`admissionId`
 join `users` `u` on `u`.`id`=`ad`.`studentId`
join `prog_batch_period_config` `per` on `sce`.`programBatchPeriodConfigId`=`per`.`id` 
join `batches` `b` on `per`.`programBatchId`=`b`.`id` join `programs` `p` on `b`.`programId`=`p`.`id`
join `academy_location` `al` on `p`.`academyLocationId`=`al`.`id` 
join `academic_term` `ac` on `per`.`academicTermId`=`ac`.`id`
left join `course_variants` `cv` on `cv`.`id`=`sce`.`courseVarientId`
left join `courses` `co` on `co`.`id`=`cv`.`courseId`
left join `sections` `sec` on `sec`.`id`=`sce`.`sectionId`
where `ac`.`whetherCurrentAcademicTerm`=true and `ad`.`activeStatus`=true and `u`.`status`=true;

END IF; 
/** view 4- student_course_enrollment_details_view End */

END $$
CALL V20210804144743__Create_ProgramBatchCourseStudentDetailView() $$ 
DROP PROCEDURE IF EXISTS V20210804144743__Create_ProgramBatchCourseStudentDetailView $$ 
DELIMITER ;