DELIMITER $$
DROP PROCEDURE IF EXISTS V20210825102211__Insert_ForGNAEmployeeIdCard $$
CREATE PROCEDURE V20210825102211__Insert_ForGNAEmployeeIdCard()
BEGIN

IF NOT EXISTS ((SELECT * FROM `report_template` WHERE `templateCode` = 'GNA_Employee_ID_Card')) THEN 
 INSERT INTO `report_template` (`reportTypeId`, `templateCode`, `templateName`, `imageLocation`, `jasperFileLocation`, `documentTypes`, `whetherDefault`, `headerJasperFileLocation`, `footerJasperFileLocation`, `repeatHeaderOnAllPages`, `repeatFooterOnAllPages`, `bodyJasperFileLocation`, `defaultHeaderLogo`)
 VALUES ('13', 'GNA_Employee_ID_Card', 'GNA Employee ID Card', 'GNA_Employee_ID_Card.png', 'CommonReport_IdCard_Vertical_AEI.jasper', 'All', '1', 'FooterBlank_IdCard.jasper', 'FooterBlank_IdCard.jasper', '1', '1', 'GNA_Employee_ID_Card.jasper', 'AcademiaLogo.png');

END IF; 


IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE `reportTemplateId` = (select id from report_template where templateCode ='GNA_Employee_ID_Card'))) THEN
   
	set @employeeIDCard = (select id from report_template where templateCode ='GNA_Employee_ID_Card');
	 
    INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`) 
	VALUES (@employeeIDCard, 'TRANS_IN_CASE_OF_LOSS', 'In case of loss, inform the loss of card to the University administration.', '1', NOW()),
    (@employeeIDCard, 'TRANS_BLOOD_GROUP', 'Blood Group', '1', NOW()),
    (@employeeIDCard, 'TRANS_EMERGENCY_CONTACT', 'Emergency Contact', '1', NOW()),
	 (@employeeIDCard, 'TRANS_ISSUING_AUTHORITY', 'Issuing Authority', '1', NOW()),
    (@employeeIDCard, 'TRANS_GNA_UNIVERSITY', 'www.gnauniversity.edu.in', '1', NOW()),
    (@employeeIDCard, 'TRANS_IF_FOUND_PLEASE_RETURN_TO', 'If found please return to: ', '1', NOW()),
    (@employeeIDCard, 'TRANS_TOLL_FREE_GNA', 'Toll Free : 1800 137 7006', '1', NOW()),
    (@employeeIDCard, 'TRANS_THIS_CARD_IS_ISSUED_BY_AND_REMAINS', 'This card is issued by and remains the property of GNA University', '1', NOW()),
     (@employeeIDCard, 'TRANS_ADDRESS_GNA', 'Shri Hargobindgarh, Phagwara- Hoshiarpur Road, Phagwara', '1', NOW()),
     (@employeeIDCard, 'TRANS_ADDRESS_PINCODE_GNA', 'Punjab- 144401', '1', NOW()),
      (@employeeIDCard, 'TRANS_ADDRESS_CONTACT_NO', 'Contact No.:01824-504999, 9876200089', '1', NOW());

  END IF;

END $$
CALL V20210825102211__Insert_ForGNAEmployeeIdCard() $$
DROP PROCEDURE IF EXISTS V20210825102211__Insert_ForGNAEmployeeIdCard $$
DELIMITER ;