DELIMITER $$
DROP PROCEDURE IF EXISTS V20210825163940__Create_PKA_PG_PBST_PBP_location $$
CREATE PROCEDURE V20210825163940__Create_PKA_PG_PBST_PBP_location()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='payment_group_acad_location')) THEN 
CREATE TABLE `payment_group_acad_location` (
  `id` BIGINT NOT NULL AUTO_INCREMENT,
  `academyLocationId` BIGINT NOT NULL,
  `paymentGroupId` BIGINT NOT NULL,
  `programBatchSeatConfigId` BIGINT NOT NULL,
  `programBatchPeriodConfigId` BIGINT NOT NULL,
  `lastUpdatedBy` BIGINT NOT NULL,
  `lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  INDEX `fk_programGroupal_users_idx` (`lastUpdatedBy` ASC) ,
  INDEX `fk_programGroupal_prog_batch_seat_config_idx` (`programBatchSeatConfigId` ASC) ,
  INDEX `fk_programGroupal_prog_batch_period_config_idx` (`programBatchPeriodConfigId` ASC) ,
  INDEX `fk_programGroupal_payment_group_idx` (`paymentGroupId` ASC) ,
  INDEX `fk_programGroupal_academyLocation_idx` (`academyLocationId` ASC) ,
  CONSTRAINT `fk_programGroupal_prog_batch_seat_config`
    FOREIGN KEY (`programBatchSeatConfigId`)
    REFERENCES `prog_batch_seat_config` (`id`)
    ON DELETE RESTRICT
    ON UPDATE RESTRICT,
  CONSTRAINT `fk_programGroupal_prog_batch_period_config`
    FOREIGN KEY (`programBatchPeriodConfigId`)
    REFERENCES `prog_batch_period_config` (`id`)
    ON DELETE RESTRICT
    ON UPDATE RESTRICT,
  CONSTRAINT `fk_programGroupal_academyLocation`
    FOREIGN KEY (`academyLocationId`)
    REFERENCES `academy_location` (`id`)
    ON DELETE RESTRICT
    ON UPDATE RESTRICT,
  CONSTRAINT `fk_programGroupal_payment_group`
    FOREIGN KEY (`paymentGroupId`)
    REFERENCES `payment_group` (`id`)
    ON DELETE RESTRICT
    ON UPDATE RESTRICT,
  CONSTRAINT `fk_programGroupal_users`
    FOREIGN KEY (`lastUpdatedBy`)
    REFERENCES `users` (`id`)
    ON DELETE RESTRICT
    ON UPDATE RESTRICT);
END IF; 

END $$
CALL V20210825163940__Create_PKA_PG_PBST_PBP_location () $$ 
DROP PROCEDURE IF EXISTS V20210825163940__Create_PKA_PG_PBST_PBP_location $$ 
DELIMITER ;