DELIMITER $$
DROP PROCEDURE IF EXISTS V20210827185443__Create_StudentContractAcceptance $$
CREATE PROCEDURE V20210827185443__Create_StudentContractAcceptance()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.TABLES WHERE table_schema=DATABASE() AND table_name='student_contract_acceptance')) THEN 
CREATE TABLE `student_contract_acceptance`(
	`id` BIGINT(20) NOT NULL AUTO_INCREMENT,  
	`admissionId` BIGINT(20) NOT NULL,
	`periodId` BIGINT(20) NOT NULL,
    `registrationTermSetupDetailId` BIGINT(20) NOT NULL,
    `lastUpdatedBy` BIGINT(20) NOT NULL,
	`lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
	PRIMARY KEY (`id`),
	CONSTRAINT `fk_student_cont_1` FOREIGN KEY (`admissionId`) REFERENCES `admission`(`id`),
	CONSTRAINT `fk_student_cont_2` FOREIGN KEY (`periodId`) REFERENCES `prog_batch_period_config`(`id`),
    CONSTRAINT `fk_student_cont_3` FOREIGN KEY (`registrationTermSetupDetailId`) REFERENCES `registration_term_setup_detail`(`id`),
	CONSTRAINT `fk_student_cont_4` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users`(`id`)
);
END IF; 

END $$
CALL V20210827185443__Create_StudentContractAcceptance () $$ 
DROP PROCEDURE IF EXISTS V20210827185443__Create_StudentContractAcceptance $$ 
DELIMITER ;