DELIMITER $$
DROP PROCEDURE IF EXISTS student_finacial_summary_till_date$$
CREATE PROCEDURE student_finacial_summary_till_date()
BEGIN
SELECT 
    concat(persons.mobileCountryCode,persons.mobileNumber) as MobileNo , persons.printName,
    concat(c.currencyCode,' ',SUM(bfprs.billableAmount)),
	concat(c.currencyCode,' ',SUM(bfprs.balanceAmount)),
    academy_location.displayName, students.userId
    
FROM
    bill_fee_plan_rule_stage AS bfprs
        LEFT OUTER JOIN
    bill_header AS bh ON bh.id = bfprs.billId
        LEFT OUTER JOIN
    currency c ON bh.currencyId = c.id
    LEFT OUTER JOIN students  on bh.studentId = students.userId
    JOIN persons on students.personId = persons.Id
JOIN admission on students.userId = admission.studentId
JOIN academy_location on academy_location.id = admission.academyLocationId
WHERE
        bh.billStatus <> 'CANCELLED'
        AND bh.raiseBillCategory = 'BILL_RECEIVABLE'
GROUP BY bh.studentId;

END $$
DELIMITER ;

