DELIMITER $$
DROP PROCEDURE IF EXISTS V20220208152512__CreateCurrentActExamMapping $$
CREATE PROCEDURE V20220208152512__CreateCurrentActExamMapping()
BEGIN 

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='current_activity_exam_mapping' )) THEN 
CREATE TABLE `current_activity_exam_mapping`( 
	`id` BIGINT(20) NOT NULL AUTO_INCREMENT, 
   `current_activity_id` BIGINT(20) NOT NULL,
    `exam_pass_id` BIGINT(20) NOT NULL,
	 `lastUpdate` TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
	 `lastUpdatedBy` BIGINT(20),
	  PRIMARY KEY (`id`), 
	  CONSTRAINT `fk_current_activity_exam_mapping_current_activity_id` FOREIGN KEY (`current_activity_id`)
        REFERENCES `current_activity` (`id`)  
        ON DELETE RESTRICT 
        ON UPDATE RESTRICT,
          CONSTRAINT `fk_current_activity_exam_mapping_exam_passed_id` FOREIGN KEY (`exam_pass_id`)
        REFERENCES `exam_passed` (`id`)
 		ON DELETE RESTRICT
 		ON UPDATE RESTRICT) 
	   ENGINE=INNODB DEFAULT 
          CHARSET=utf8; 
END IF; 

IF  EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='standard_master')) THEN 
INSERT INTO `standard_master` (`childMaster`,`tableName`,`masterName`,`moduleName`,`filterCode`,`whetherChild`,`whetherParent`,`droolsAgenda`,`displayValue`,`lastUpdatedBy`,
`lastUpdate`)
VALUES (NULL,'current_activity_exam_mapping','CURRENT_ACTIVITY_EXAM_MAPPING',"Admissions",'COMMON_MASTER',1,0,NULL,NULL,1,now());
END IF; 


SET SQL_SAFE_UPDATES=0;
IF  EXISTS ((SELECT * FROM `standard_master` WHERE tableName = 'current_activity' and masterName = 'CURRENT_ACTIVITY')) THEN 
SET @standardMasterId=(select id from standard_master where tableName = 'current_activity_exam_mapping');
update standard_master set childMaster = @standardMasterId, whetherParent = 1  where tableName = 'current_activity';
END IF; 
SET SQL_SAFE_UPDATES=1;


IF  EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='standard_master_items')) THEN 
SET @standardMaster=(SELECT id FROM standard_master where  tableName ='current_activity_exam_mapping');
INSERT INTO standard_master_items (`dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`, `diaplayOrder`, `whetherForeignKey`, `fkTable`, `fkFieldName`, `fkDisplayField`, `whetherShortCode`, `whetherReadOnly`, `wheherNullable`, `lastUpdatedBy`, `lastUpdate`) 
VALUES ('examPassed', 'EXAM_PASSED', @standardMaster, 'Varchar', '1', 1, 'exam_passed', 'id','value', 0, 0, 1, '1', SYSDATE());

END IF;

END $$
CALL V20220208152512__CreateCurrentActExamMapping () $$ 
DROP PROCEDURE IF EXISTS V20220208152512__CreateCurrentActExamMapping $$ 
DELIMITER ;