DELIMITER $$
DROP PROCEDURE IF EXISTS V20220214150639__Create_ApplicationAdhocDocTable $$
CREATE PROCEDURE V20220214150639__Create_ApplicationAdhocDocTable()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='application_adhoc_documents')) THEN 
CREATE TABLE `application_adhoc_documents`(  
  `id` BIGINT(20) NOT NULL AUTO_INCREMENT,
  `applicationId` BIGINT(20) NOT NULL,
  `documentId` BIGINT(20) NOT NULL,
  `remark` VARCHAR(255) NULL,
  `lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `lastUpdatedBy` BIGINT(20) NOT NULL,
  PRIMARY KEY (`id`),
  CONSTRAINT `application_adhoc_documents_applicationId_FK` FOREIGN KEY (`applicationId`) REFERENCES `application`(`id`),
  CONSTRAINT `application_adhoc_documents_documentId_FK` FOREIGN KEY (`documentId`) REFERENCES `documents`(`id`),
  CONSTRAINT `application_adhoc_documents_lastUpdatedBy_FK` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users`(`id`))
ENGINE=INNODB DEFAULT  CHARSET=utf8;
END IF; 

END $$
CALL V20220214150639__Create_ApplicationAdhocDocTable () $$ 
DROP PROCEDURE IF EXISTS V20220214150639__Create_ApplicationAdhocDocTable $$ 
DELIMITER ;