DELIMITER $$
DROP PROCEDURE IF EXISTS V20220808153055__Create_PostDocInfoDocumentTable $$
CREATE PROCEDURE V20220808153055__Create_PostDocInfoDocumentTable()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='post_doc_info_documents')) THEN 
CREATE TABLE  `post_doc_info_documents` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `documentId` bigint(20) NOT NULL,
  `postDocInfoId` bigint(20) NOT NULL,
  `lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `lastUpdatedBy` bigint(20) NOT NULL,
  PRIMARY KEY (`id`),
  CONSTRAINT `post_doc_info_documents_documentId_FK` FOREIGN KEY (`documentId`) REFERENCES `documents`(`id`),
  CONSTRAINT `post_doc_info_documents_postDocInfoId_FK` FOREIGN KEY (`postDocInfoId`) REFERENCES `post_doc_info`(`id`),
  CONSTRAINT `post_doc_info_documents_lastUpdatedBy_FK` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users`(`id`))
ENGINE=InnoDB AUTO_INCREMENT=125 DEFAULT CHARSET=utf8;
END IF; 

END $$
CALL V20220808153055__Create_PostDocInfoDocumentTable () $$ 
DROP PROCEDURE IF EXISTS V20220808153055__Create_PostDocInfoDocumentTable $$ 
DELIMITER ;