DELIMITER $$
DROP PROCEDURE IF EXISTS V20220909174918__Create_AppAndAdmCommentsEvent $$
CREATE PROCEDURE V20220909174918__Create_AppAndAdmCommentsEvent()
BEGIN

IF NOT EXISTS ((SELECT * FROM msg_category WHERE `code`='APPLICATION_AND_ADMISSION_COMMENTS')) THEN
SET @parentcategoryId=(SELECT id FROM msg_category WHERE `code`='ADMISSION');
SET @msgcategoryId=(SELECT MAX(id) FROM msg_category);
INSERT INTO `msg_category` (`id`,`parentCategory`,`code`) VALUES (@msgcategoryId+1,@parentcategoryId,'APPLICATION_AND_ADMISSION_COMMENTS');

SET @systemmsgeventId=(SELECT MAX(id) FROM system_msg_event);
SET @msgSubCategoryId=(SELECT id FROM msg_category WHERE `code`='APPLICATION_AND_ADMISSION_COMMENTS');
INSERT INTO `system_msg_event`
(`id`, `msgConfigLevelId`, `msgSubCategoryId`, `code`, `displayCode`, `eventType`, `whetherRepetationApplicable`, `whetherInitiationRuleApplicable`, `whetherScheduledEvent`, `whetherMsgScopeApplicable`, `whetherImplicitDistributionList`, `whetherDistributionRuleApplicable`, `whetherCommonMsgTemplate`, `description`)
VALUES (@systemmsgeventId+1, '1', @msgSubCategoryId, 'APPLICATION_AND_ADMISSION_COMMENTS', 'Application & Admission Comments', 'SYSTEM', 0, 0, 0, 0, 1, 0, 0, 'Application & Admission Comments');


SET @sysmsgevtdefaultconfId=(SELECT MAX(id) FROM sys_msg_evt_default_conf);
INSERT INTO `sys_msg_evt_default_conf` (`id`, `systemMsgEventId`, `msgTemplateConfigId`, `initiationRuleProviderId`, `sendingPriority`)
VALUES (@sysmsgevtdefaultconfId+1, @systemmsgeventId+1, NULL, NULL, 'IMMEDIATE');

SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='CONTEXT_RECORD_ID');
INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1, @sysmsgevtdefaultconfId+1, @msgScopeParamId);

SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='EVENT_TRIGGER_DATE');
INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1, @sysmsgevtdefaultconfId+1, @msgScopeParamId);

SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='CONFIG_LEVEL_VALUE');
INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1, @sysmsgevtdefaultconfId+1, @msgScopeParamId);

SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='ACADEMY_LOCATION_IDS');
INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1	, @sysmsgevtdefaultconfId+1, @msgScopeParamId);


-- Template data provider for the Event

SET @dtproviderId=(SELECT MAX(id) FROM dtprovider);
INSERT INTO `dtprovider` (`id`, `dataProviderName`, `dataProviderType`) VALUES (@dtproviderId+1, 'APPLICATION_AND_ADMISSION_COMMENTS_DL', 'SQL');

SET @dtproviderId=(SELECT MAX(id) FROM dtprovider);
INSERT INTO `dtprovider` (`id`, `dataProviderName`, `dataProviderType`) VALUES (@dtproviderId+1, 'APPLICATION_AND_ADMISSION_COMMENTS_RECIPIENT', 'SQL');

-- Create Recipient Type

SET @msgRecipientId=(SELECT MAX(id) FROM msg_recipient_type);
SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='APPLICATION_AND_ADMISSION_COMMENTS_RECIPIENT');
INSERT INTO `msg_recipient_type` (`id`, `recipientDataProviderId`, `code`) VALUES (@msgRecipientId+1, @dtproviderId, 'APPLICATION_AND_ADMISSION_COMMENTS_RECIPIENT');


SET @sysmsgevtrcptdefaultconfId=(SELECT MAX(id) FROM `sys_msg_evtrcpt_default_conf`);
SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='APPLICATION_AND_ADMISSION_COMMENTS_DL');
SET @recipientTypeId=(SELECT id FROM `msg_recipient_type` WHERE `code`='APPLICATION_AND_ADMISSION_COMMENTS_RECIPIENT');
INSERT INTO `sys_msg_evtrcpt_default_conf` (`id`, `sysMsgEvtDefaultConfId`, `distrListProviderId`, `distrRuleProviderId`, `recipientTypeId`)
VALUES (@sysmsgevtrcptdefaultconfId+1, @sysmsgevtdefaultconfId+1, @dtproviderId, NULL, @recipientTypeId);


-- Setting the query for the Applicant distribution list

SET @sqlDtproviderId=(SELECT MAX(id) FROM `sql_dtprovider`);
SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='APPLICATION_AND_ADMISSION_COMMENTS_DL');
INSERT INTO `sql_dtprovider` (`id`, `dataProviderId`, `sqlQuery`, `jsonString`) VALUES (@sqlDtproviderId+1,@dtproviderId,"SELECT T1.id as USER_ID FROM application_admission_comments T1 WHERE T1.id IN (namedParams)",NULL);


-- Setting the query for the User Recipient

SET @sqlDtproviderId=(SELECT MAX(id) FROM `sql_dtprovider`);
SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='APPLICATION_AND_ADMISSION_COMMENTS_RECIPIENT');
INSERT INTO sql_dtprovider (id, dataProviderId, sqlQuery, jsonString) VALUES (@sqlDtproviderId+1,@dtproviderId,
"SELECT
    T3.`id` AS ID,    
    T4.`printName` AS APP_AND_ADM_COMMENTS_REASSIGN_TO,
    T5.`code` AS APP_AND_ADM_COMMENTS_APPLICATION_CODE,
    T6.`printName` AS APP_AND_ADM_COMMENTS_APPLICATION_NAME
FROM
    application_admission_comments T3
LEFT OUTER JOIN
    users T4 ON T4.id = T3.reassignUserId
        LEFT OUTER JOIN
    application T5 ON T5.id = T3.applicationId
        LEFT OUTER JOIN
    applicant_person T6 ON T6.id = T5.applicantPersonId
WHERE
    T3.id IN (namedParams)",'{
    "id": 1,
    "searchResultViewColumns": [
        {
            "id": 2,
            "value": "printName",
            "resultKey": "APP_AND_ADM_COMMENTS_REASSIGN_TO",
            "displayCode": "",
            "displayOrder": 1
        },
        {
            "id": 3,
            "value": "code",
            "resultKey": "APP_AND_ADM_COMMENTS_APPLICATION_CODE",
            "displayCode": "",
            "displayOrder": 2
        },
        {
            "id": 4,
            "value": "printName",
            "resultKey": "APP_AND_ADM_COMMENTS_APPLICATION_NAME",
            "displayCode": "",
            "displayOrder": 3
        }
    ]
}');

SET @dtprvdrinputparamId=(SELECT MAX(id) FROM dtprvdr_input_param);
SET @dtproviderId=(SELECT id FROM `dtprovider` where `dataProviderName`='APPLICATION_AND_ADMISSION_COMMENTS_DL');
SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='CONFIG_LEVEL_VALUE');
INSERT INTO `dtprvdr_input_param` (`id`, `dataProviderId`, `paramName`, `paramDataType`, `paramType`, `msgScopeParamId`, `operatorCode`, `additionalInputParamId`) VALUES(@dtprvdrinputparamId+1,@dtproviderId,'T3.id','NUMBER_EQUAL','SCOPEPARAM',@msgScopeParamId,'NUMBER_EQUAL',NULL);

SET @msgtemplateId=(SELECT MAX(id) FROM msg_template);
SET @sysMsgEventId=(SELECT id FROM system_msg_event where code='APPLICATION_AND_ADMISSION_COMMENTS');

SET @msgtemplateconfigId=(SELECT MAX(id) FROM msg_template_config);
SET @msgSubCategoryId=(SELECT id FROM `msg_category` WHERE `code`='APPLICATION_AND_ADMISSION_COMMENTS');
SET @recipientTypeId=(SELECT id FROM `msg_recipient_type` WHERE `code`='APPLICATION_AND_ADMISSION_COMMENTS_RECIPIENT');
SET @msgMessageTypeId=(SELECT id FROM `msg_message_type` WHERE `code`='Notifications');


INSERT INTO `msg_template_config` (`id`, `code`, `msgSubCategoryId`, `sysMsgEventId`, `recipientTypeId`, `msgMessageTypeId`, `templateDataProviderId`, `templateConfigType`, `templateConfigName`, `whetherBulkMesaging`, `approvalRequired`, `approverId`, `whetherStaticMsg`, `status`, `availableForAdhocMsg`, `academyLocationId`, `authorName`, `authorId`,`whetherEnabled`,`templatelanguageValue`)
VALUES(@msgtemplateconfigId+1,'Application & Admission Comments',@msgSubCategoryId,@sysMsgEventId,@recipientTypeId,@msgMessageTypeId,NULL,NULL,'Application & Admission Comments',NULL,'',NULL,'','APPROVED','','1','System Admin System Admin','1',b'1','English');


INSERT INTO `msg_template` (`id`, `msgTemplateConfigId`, `msgDeliveryModeId`, `subjectLine`, `msgContent`)
VALUES (@msgtemplateId+1,@msgtemplateconfigId+1,'4','Application & Admission Comments','<html>
<head>
    <title></title>
</head>
<body>
<table align="center" style="min-width:700px; max-width:800px; border-collapse:collapse">
    <tbody>
        <tr style="background-color:#f0f0f0; line-height:20px;">
            <td style="padding:20px 20px 20px 20px;">
            <p style="font-family:sans-serif, Arial, Helvetica; font-size:14px">Dear <strong>$recipientData[&quot;APP_AND_ADM_COMMENTS_REASSIGN_TO&quot;] </strong>,</p>
            <p style="font-family:sans-serif, Arial, Helvetica; font-size:14px">Please note that the following application and Admission comment assigned to you Kindly Review for <strong>$recipientData[&quot;APP_AND_ADM_COMMENTS_APPLICATION_CODE&quot;]&nbsp;/&nbsp;$recipientData[&quot;APP_AND_ADM_COMMENTS_APPLICATION_NAME&quot;]</strong>.</p>
            </td>
        </tr>
    </tbody>
</table>
</body>
</html>');

-- End Messaging for APPLICATION_AND_ADMISSION_COMMENTS Event
END IF;

END $$
CALL V20220909174918__Create_AppAndAdmCommentsEvent() $$
DROP PROCEDURE IF EXISTS V20220909174918__Create_AppAndAdmCommentsEvent $$
DELIMITER ;