DELIMITER $$
DROP PROCEDURE IF EXISTS V20220915121337__Create_StudentOwnProgressReport $$
CREATE PROCEDURE V20220915121337__Create_StudentOwnProgressReport()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='student_own_progress_report')) THEN 
CREATE TABLE `student_own_progress_report` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `personId` BIGINT(20) NOT NULL,
  `progressReportStartDate` Date NOT NULL,
  `progressReportEndDate` Date NOT NULL,
  `auditDate` date DEFAULT NULL,
  `auditId` bigint NOT NULL,
  `lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `lastUpdatedBy` BIGINT(20) NOT NULL,
  PRIMARY KEY (`id`),
  CONSTRAINT `FK_stdownprogress_SU_person` FOREIGN KEY (`personId`) REFERENCES `persons` (`id`),
  CONSTRAINT `FK_stdownprogress_SU_auditId` FOREIGN KEY (`auditId`) REFERENCES `users` (`id`),
  CONSTRAINT `FK_stdownprogress_SU_lastUpdatedBy_FK` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users`(`id`)
) ;
END IF;

END $$
CALL V20220915121337__Create_StudentOwnProgressReport () $$ 
DROP PROCEDURE IF EXISTS V20220915121337__Create_StudentOwnProgressReport $$ 
DELIMITER ;