DELIMITER $$
DROP PROCEDURE IF EXISTS V20220921154344__Insert_WIIAEmployeeIDCard $$
CREATE PROCEDURE V20220921154344__Insert_WIIAEmployeeIDCard()
BEGIN

IF NOT EXISTS ((SELECT * FROM `report_template` WHERE templateCode = 'Indus_WIIA_Employee_ID_Card')) THEN 
INSERT INTO `report_template` (`reportTypeId`, `templateCode`, `templateName`, `imageLocation`, `jasperFileLocation`, `documentTypes`, `whetherDefault`, `headerJasperFileLocation`, `footerJasperFileLocation`, `repeatHeaderOnAllPages`, `repeatFooterOnAllPages`, `bodyJasperFileLocation`, `defaultHeaderLogo`) 
VALUES ('13', 'Indus_WIIA_Employee_ID_Card', 'WIIA_Employee_ID_Card', 'WIIA_Employee_ID_Card.png', 'CommonReport.jasper', 'All', '1', 'FooterBlank.jasper', 'FooterBlank.jasper', '1', '1', 'WIIA_Employee_ID_Card.jasper', 'AcademiaLogo.png');
END IF; 

set @WIIA_Employee_ID_Card = (select max(id) from report_template where templateCode ='Indus_WIIA_Employee_ID_Card');

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @WIIA_Employee_ID_Card and keyValue='ISSUING_AUTHORITY ')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@WIIA_Employee_ID_Card, 'ISSUING_AUTHORITY', 'Issuing Authority ', '1', NOW());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @WIIA_Employee_ID_Card and keyValue='TAGLINE_FRONT')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@WIIA_Employee_ID_Card, 'TAGLINE_FRONT', "“Engineering is Tradition & Maintenance is our culture”", '1', NOW());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @WIIA_Employee_ID_Card and keyValue='TAGLINE_BACK')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@WIIA_Employee_ID_Card, 'TAGLINE_BACK', 'INSTRUCTION- This card is the Property of WIIA Ahmedabad and is not Transferable Finder May mail it to the institute  address given on the Card.', '1', NOW());
END IF;

END $$
CALL V20220921154344__Insert_WIIAEmployeeIDCard() $$
DROP PROCEDURE IF EXISTS V20220921154344__Insert_WIIAEmployeeIDCard $$
DELIMITER ;