DELIMITER $$
DROP PROCEDURE IF EXISTS V20221027135911__Alter_ForCreditFeeMappingOnlinePayment $$
CREATE PROCEDURE V20221027135911__Alter_ForCreditFeeMappingOnlinePayment()
BEGIN


IF NOT EXISTS ((SELECT * FROM information_schema.columns WHERE table_schema=DATABASE() AND table_name='online_course_enrollment_master')) THEN 
CREATE TABLE `online_course_enrollment_master` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `status` varchar(255) DEFAULT NULL,
  `receiptAmount` double(20,2) DEFAULT NULL,
  `transactionDate` date DEFAULT NULL,
  `receiptId` bigint(20) DEFAULT NULL,
  `whetherSettled` bit(1) DEFAULT b'0',
  `receiptFor` varchar(255) DEFAULT NULL,
  `transactionFees` DOUBLE(20,2) DEFAULT NULL,
  `txnid` varchar(255) DEFAULT NULL,
  `studentId` BIGINT DEFAULT NULL,
  `progBatchSeatConfigId` BIGINT DEFAULT NULL,
  `periods` varchar(255) DEFAULT NULL,
  `portalId` BIGINT DEFAULT NULL,
  `paymentTermId` BIGINT DEFAULT NULL,
  `isPaylater` bit(1) DEFAULT false,
  `isActive` BIT(1) DEFAULT NULL,
  `lastUpdatedBy` BIGINT NOT NULL,
  `lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
  ) ENGINE=InnoDB DEFAULT CHARSET=utf8;
END IF; 


IF NOT EXISTS ((SELECT * FROM information_schema.columns WHERE table_schema=DATABASE() AND table_name='online_course_enrollment')) THEN 
CREATE TABLE `online_course_enrollment` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `onlineCourseEnrollmentMasterId` bigint(20) NOT NULL,
  `courseId` bigint(20) DEFAULT NULL,
  `courseVariantId` bigint(20) DEFAULT NULL,
  `sectionId` bigint(20) DEFAULT NULL,
  `batchId` bigint(20) DEFAULT NULL,
  `periodId` bigint(20) DEFAULT NULL,
  `courseStatus` varchar(255) DEFAULT NULL,
  `whetherOptional` bit(1) DEFAULT b'0',
  `whetherCourseExempted` bit(1) DEFAULT b'0',
  `sectionType` varchar(255) DEFAULT NULL,
  `studentCourseEnrollmentCriteria` varchar(255) DEFAULT NULL,
  `midtermGrade` varchar(255) DEFAULT NULL,
  `feePlanRuleId` bigint(20) DEFAULT NULL,
  `admissionId` bigint(20) DEFAULT NULL,
  `studentId` bigint(20) DEFAULT NULL,
  `courseGroupId` bigint(20) DEFAULT NULL,
  `billId` bigint(20) DEFAULT NULL,
  `isActive` BIT(1) DEFAULT NULL, 
  `whetherCreditBased` BIT(1) DEFAULT false,
  `creditPerCourse` BIGINT DEFAULT NULL ,
  `courseFeeDefinitionId` BIGINT DEFAULT NULL ,
  `amount` double(20,2) DEFAULT NULL,
  `courseRepetitionFeeDefinitionId` BIGINT DEFAULT NULL ,
  `isEvenPeriod` bit(1) DEFAULT false,
  `creditFeeMappingId` BIGINT DEFAULT NULL ,
  `creditFeeAmount` double(20,2) DEFAULT NULL,
  `lastUpdatedBy` BIGINT NOT NULL,
  `lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `fk_online_course_enrollment_master1_idx` (`onlineCourseEnrollmentMasterId`),
  CONSTRAINT `fk_online_course_enrollment_master1` FOREIGN KEY (`onlineCourseEnrollmentMasterId`) REFERENCES `online_course_enrollment_master` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
END IF;  
	
	


END $$
CALL V20221027135911__Alter_ForCreditFeeMappingOnlinePayment() $$
DROP PROCEDURE IF EXISTS V20221027135911__Alter_ForCreditFeeMappingOnlinePayment $$
DELIMITER ;