DELIMITER $$
DROP PROCEDURE IF EXISTS V20221116144323__Create_CreateLeaveOfAbsenceServiceReqDtls $$
CREATE PROCEDURE V20221116144323__Create_CreateLeaveOfAbsenceServiceReqDtls()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='leave_of_absence_request_details')) THEN

CREATE TABLE `leave_of_absence_request_details` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `programId` bigint(20) NOT NULL,
  `batchId` bigint(20) NOT NULL,
  `seatTypeId` bigint(20) NOT NULL,
  `periodId` bigint(20) NOT NULL,
  `serviceRequestId` BIGINT NULL DEFAULT NULL,
  `admissionId` BIGINT NULL DEFAULT NULL,
  `studentReturnStatus` bigint DEFAULT NULL,
  `version` BIGINT NULL DEFAULT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`),
  INDEX `fk_program_Id_idx` (`programId` ASC),
  INDEX `fk_batch_Id_idx` (`batchId` ASC),
  INDEX `fk_seatType_Id_idx` (`seatTypeId` ASC),
  INDEX `fk_period_Id_idx` (`periodId` ASC),
  INDEX `fk_serviceRequest_Id_idx` (`serviceRequestId` ASC),
  INDEX `fk_admision_Id_idx` (`admissionId` ASC),
  INDEX `fk_applicant_person_interventions_lastUpdateBy_idx` (`lastUpdatedBy` ASC),

  CONSTRAINT `fk_loas_programId` 
	FOREIGN KEY (`programId`)
	REFERENCES `programs` (`id`),
  CONSTRAINT `fk_loas_batchId` 
	FOREIGN KEY (`batchId`) 
	REFERENCES `batches` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
   CONSTRAINT `fk_loas_seatTypeId` 
	FOREIGN KEY (`seatTypeId`) 
	REFERENCES `seat_types` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fk_loas_periodId` 
	FOREIGN KEY (`periodId`) 
	REFERENCES `prog_batch_period_config` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fk_loas_lastUpdated` 
	FOREIGN KEY (`lastUpdatedBy`) 
	REFERENCES `users` (`id`),
  CONSTRAINT `fk_loas_service_requestId` 
	FOREIGN KEY (`serviceRequestId`) 
	REFERENCES `service_requests` (`id`),
  CONSTRAINT `fk_loas_admissionId`
  FOREIGN KEY (`admissionId`)
  REFERENCES `admission` (`id`)
  ON DELETE NO ACTION
  ON UPDATE NO ACTION);
END IF;

END $$
CALL V20221116144323__Create_CreateLeaveOfAbsenceServiceReqDtls () $$ 
DROP PROCEDURE IF EXISTS V20221116144323__Create_CreateLeaveOfAbsenceServiceReqDtls $$ 
DELIMITER ;