DELIMITER $$
DROP PROCEDURE IF EXISTS V20221219145359__Insert_UWC_Receipt_Settlement_Student $$
CREATE PROCEDURE V20221219145359__Insert_UWC_Receipt_Settlement_Student()
BEGIN
set @reportTypeTempId = (select max(id) from report_type where typeName='Receipt With Settlement' );

IF NOT EXISTS ((SELECT * FROM `report_template` where `reportTypeId`=@reportTypeTempId and `templateCode`='MANAGE_RECEIPT_SETTLEMENT_STUDENT_CODE' and `templateName`='UWC Student Receipt with Settlement')) THEN
INSERT INTO `report_template` (`reportTypeId`, `templateCode`, `templateName`, `imageLocation`, `jasperFileLocation`, `documentTypes`, `whetherDefault`, `headerJasperFileLocation`, `footerJasperFileLocation`, `repeatHeaderOnAllPages`, `repeatFooterOnAllPages`, `bodyJasperFileLocation`, `defaultHeaderLogo`)
VALUES (@reportTypeTempId, 'MANAGE_RECEIPT_SETTLEMENT_STUDENT_CODE', 'UWC Receipt with Settlement Student', 'RECEIPT_WITH_SETTLEMENT_STUDENT_CODE_UWC.png', 'CommonReport.jasper', 'All', '0', 'FooterBlank.jasper', 'FooterBlank.jasper', '0', '0', 'RECEIPT_WITH_SETTLEMENT_STUDENT_CODE_UWC.jasper', 'AcademiaLogo.jpg');
END IF;

set @rID = (select max(id) from report_template where templateCode ='MANAGE_RECEIPT_SETTLEMENT_STUDENT_CODE');

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @rID and keyValue='TRANS_RECEIPT')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@rID, 'TRANS_RECEIPT', 'Receipt', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @rID and keyValue='TRANS_RECEIPT_NO')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@rID, 'TRANS_RECEIPT_NO', 'Receipt No', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @rID and keyValue='TRANS_RECEIPT_DATE')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@rID, 'TRANS_RECEIPT_DATE', 'Receipt Date', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @rID and keyValue='TRANS_STUDENT_NAME')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@rID, 'TRANS_STUDENT_NAME', 'Student Name', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @rID and keyValue='TRANS_STUDENT_NUMBER')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@rID, 'TRANS_STUDENT_NUMBER', 'Student Number', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @rID and keyValue='TRANS_INTAKE')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@rID, 'TRANS_INTAKE', 'Intake', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @rID and keyValue='TRANS_ADMISSION_DATE')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@rID, 'TRANS_ADMISSION_DATE', 'Admission Date', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @rID and keyValue='TRANS_SHORT_COURSE/PROGRAMME')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@rID, 'TRANS_SHORT_COURSE/PROGRAMME', 'Short Course/Programme', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @rID and keyValue='TRANS_PARTICULARS')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@rID, 'TRANS_PARTICULARS', 'Particulars', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @rID and keyValue='TRANS_AMOUNT')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@rID, 'TRANS_AMOUNT', 'Amount', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @rID and keyValue='TRANS_TOTAL')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@rID, 'TRANS_TOTAL', 'Total', '1', now());
END IF;



IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @rID and keyValue='TRANS_PAYMENT_MODE')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@rID, 'TRANS_PAYMENT_MODE', 'Payment Mode', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @rID and keyValue='TRANS_Trans._Type')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@rID, 'TRANS_Trans._Type', 'Trans. Type', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @rID and keyValue='TRANS_REFERENCE_NUMBER')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@rID, 'TRANS_REFERENCE_NUMBER', 'Reference Number', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @rID and keyValue='TRANS_DATE')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@rID, 'TRANS_DATE', 'Date', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @rID and keyValue='TRANS_RECEIVED_A_SUM_OF')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@rID, 'TRANS_RECEIVED_A_SUM_OF', 'Received a sum of', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @rID and keyValue='TRANS_AUTHORIZED_SIGNATORY_WITH_SEAL')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@rID, 'TRANS_AUTHORIZED_SIGNATORY_WITH_SEAL', 'Authorized signatory with seal', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @rID and keyValue='TRANS_TERMS_AND_CONDITIONS')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@rID, 'TRANS_TERMS_AND_CONDITIONS', 'Terms and Conditions', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @rID and keyValue='TRANS_TERMS_AND_CONDITION_POINT_ONE')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@rID, 'TRANS_TERMS_AND_CONDITION_POINT_ONE', 'This is an original receipt and shall be issued only once.', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @rID and keyValue='TRANS_TERMS_AND_CONDITION_POINT_TWO')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@rID, 'TRANS_TERMS_AND_CONDITION_POINT_TWO', 'For refunds, please refer to the terms & conditions on the Pillar Seven website.', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @rID and keyValue='TRANS_TERMS_AND_CONDITION_POINT_THREE')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@rID, 'TRANS_TERMS_AND_CONDITION_POINT_THREE', '', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @rID and keyValue='TRANS_TERMS_AND_CONDITION_POINT_FOUR')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@rID, 'TRANS_TERMS_AND_CONDITION_POINT_FOUR', '', '1', now());
END IF; 


END $$
CALL V20221219145359__Insert_UWC_Receipt_Settlement_Student() $$
DROP PROCEDURE IF EXISTS V20221219145359__Insert_UWC_Receipt_Settlement_Student $$
DELIMITER ;