DELIMITER $$
DROP PROCEDURE IF EXISTS V20230214144616__Create_LessionPlanningTypeCSM $$
CREATE PROCEDURE V20230214144616__Create_LessionPlanningTypeCSM()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='lession_planning_type')) THEN 
CREATE TABLE `lession_planning_type` (
	`id` BIGINT(20) NOT NULL AUTO_INCREMENT,  
	`itemCode` VARCHAR(100) NOT NULL,
	`itemValue` VARCHAR(100) NOT NULL,
	`lastUpdatedBy` BIGINT(20) NOT NULL,
	`lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
	PRIMARY KEY (`id`),
	UNIQUE KEY itemCode_UNIQUE (itemCode),
    KEY fk_lession_planning_type_lastUpdatedBy_idx (lastUpdatedBy),
    CONSTRAINT fk_lession_planning_type_lastUpdatedBy FOREIGN KEY (lastUpdatedBy) REFERENCES users(id)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
END IF; 

-- CSM Data

SET @currentTimeStamp = (SELECT CURRENT_TIMESTAMP);
SET @standardMasterMaxId=(SELECT MAX(id) FROM standard_master);

IF NOT EXISTS ((SELECT * FROM standard_master WHERE tableName = 'lession_planning_type')) THEN
INSERT INTO `standard_master`(`id`,`childMaster`,`tableName`,`masterName`,`moduleName`,`filterCode`,`whetherChild`,`whetherParent`, `droolsAgenda`,`lastUpdatedBy`,`lastUpdate`) 
VALUES (@standardMasterMaxId+1, NULL,'lession_planning_type','LESSION_PLANNING_TYPE','Program & Courses','COMMON_MASTER',0,0,NULL,1,@currentTimeStamp);
END IF;


IF  EXISTS ((select * from standard_master where tableName = 'lession_planning_type')) THEN 
SET @standardMasterId=(select id from standard_master where tableName = 'lession_planning_type');
IF NOT EXISTS ((select * from standard_master_items where standardMasterId = @standardMasterId and fieldLabel='TYPE_CODE')) THEN
INSERT INTO `standard_master_items` (`dbFieldName`,`fieldLabel`,`standardMasterId`,`fieldType`,`emunType`,`diaplayOrder`,`whetherForeignKey`,`fkTable`,`fkFieldName`,`fkDisplayField`,`whetherShortCode`,`whetherReadOnly`,`wheherNullable`,`validationType`,`maxLength`,`minLength`,`lastUpdatedBy`,`lastUpdate`)
VALUES ('code','TYPE_CODE',@standardMasterId,'Varchar',NULL,1,0,NULL,NULL,NULL,0,0,0,NULL,NULL,NULL,1,now());
END IF;
IF NOT EXISTS ((select * from standard_master_items where standardMasterId = @standardMasterId and fieldLabel='TYPE_VALUE')) THEN
INSERT INTO `standard_master_items` (`dbFieldName`,`fieldLabel`,`standardMasterId`,`fieldType`,`emunType`,`diaplayOrder`,`whetherForeignKey`,`fkTable`,`fkFieldName`,`fkDisplayField`,`whetherShortCode`,`whetherReadOnly`,`wheherNullable`,`validationType`,`maxLength`,`minLength`,`lastUpdatedBy`,`lastUpdate`)
VALUES ('value','TYPE_VALUE',@standardMasterId,'Varchar',NULL,2,0,NULL,NULL,NULL,0,0,0,NULL,NULL,NULL,1,now());
END IF;
END IF; 

-- ------------------TRANSLATION-------------------------------------------------

IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE objectName = 'masterNames' and keyName = 'LESSION_PLANNING_TYPE')) THEN 
INSERT INTO `ui_translation` (`objectName`, `keyName`, `defaultValue`, `customerDefineValue`,`afriLanguage`,`vietLanguage`,`lastUpdate`,`lastUpdatedBy`)
VALUES ('masterNames', 'LESSION_PLANNING_TYPE', 'Lession Planning Type', 'Lession Planning Type','Tipes lesbeplanning','Các loại kế hoạch bài học',now(),1);
END IF;


END $$
CALL V20230214144616__Create_LessionPlanningTypeCSM () $$ 
DROP PROCEDURE IF EXISTS V20230214144616__Create_LessionPlanningTypeCSM $$ 
DELIMITER ;