DELIMITER $$
DROP PROCEDURE IF EXISTS V20230328190132__Create_business_rule $$
CREATE PROCEDURE V20230328190132__Create_business_rule()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='business_rule')) THEN 
CREATE TABLE `business_rule` (
  `id` BIGINT NOT NULL AUTO_INCREMENT,
  `codeValue` VARCHAR(255) NOT NULL,
  `nameValue` VARCHAR(255) NOT NULL,
  `businessRuleStatus` BIT NOT NULL DEFAULT FALSE,
  `approvalStatus` BIT NOT NULL DEFAULT FALSE,
  `roleId` BIGINT NULL,
  `lastUpdate` TIMESTAMP NOT NULL DEFAULT now(),
  `lastUpdatedBy` BIGINT NOT NULL,
  PRIMARY KEY (`id`),
  INDEX `fk_business_rule_roleId_idx` (`roleId` ASC),
  INDEX `fk_business_rule_user_idx` (`lastUpdatedBy` ASC),
  CONSTRAINT `fk_business_rule_roleId`
    FOREIGN KEY (`roleId`)
    REFERENCES `roles` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `fk_business_rule_user_idx`
    FOREIGN KEY (`lastUpdatedBy`)
    REFERENCES `users` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION);

END IF; 

END $$
CALL V20230328190132__Create_business_rule () $$ 
DROP PROCEDURE IF EXISTS V20230328190132__Create_business_rule $$ 
DELIMITER ;