DELIMITER $$
DROP PROCEDURE IF EXISTS V20230411161554__Update_OutstandingBillReminderRecipient $$
CREATE PROCEDURE V20230411161554__Update_OutstandingBillReminderRecipient()
BEGIN
SET SQL_SAFE_UPDATES=0;
IF NOT EXISTS ((SELECT id FROM dtprovider WHERE dataProviderName='OUTSTANDING_BILL_STU_REM_ON_DAY_RCPNT')) THEN 

SET @studentReminderOnDueDay=(SELECT id FROM dtprovider WHERE dataProviderName='OUTSTANDING_BILL_STU_REM_ON_DAY_RCPNT');

UPDATE sql_dtprovider SET sqlQuery=
"SELECT
bh.id AS ID,
SUM(bfprs.balanceAmount) as OUTSTANDING_AMT,
bh.studentId,
p.emailId AS EMAIL_ID,
p.mobileNumber AS MOBILE_NO,
p.mobileCountryCode AS MOBILE_CODE,
p.printName AS PRINT_NAME,
p.firstName AS FIRST_NAME,
p.lastName AS LAST_NAME,
sal.salutationName AS SALUTATION_NAME,
bh.billNo AS BILL_NO,
DATE_FORMAT(bh.billingDate, '%d-%m-%Y') AS BILL_DATE,
DATE_FORMAT(bh.dueDate, '%d-%m-%Y') AS BILL_DUE_DATE,
T6.displayName AS ACADEMY_NAME,
ml.code as LANGUAGE_KEY,
(select GROUP_CONCAT(DISTINCT deviceTokenId) from fire_base_persons_info where fire_base_persons_info.userId=bh.studentId) AS DEVICE_ID
FROM
bill_header bh
JOIN
bill_fee_plan_rule_stage bfprs ON bfprs.billId = bh.id
JOIN
students s ON s.userId = bh.studentId
JOIN
persons p ON p.id = s.personId
LEFT JOIN
salutations sal ON sal.id = p.salutationId
LEFT JOIN
academy_location T6 ON T6.id = bh.academyLocationId
LEFT JOIN
multi_language ml on ml.id=p.correspondence_language
WHERE
bh.id IN (namedParams)
AND bh.billStatus NOT IN ('CANCELLED' , 'SETTLED') group by bh.id
" WHERE dataProviderId=@studentReminderOnDueDay;

END IF; 

IF NOT EXISTS ((SELECT id FROM dtprovider WHERE dataProviderName='OUTSTANDING_BILL_STU_REM_ON_DAY_S2_RCPNT')) THEN 
SET @studentReminderOnDueDay2=(SELECT id FROM dtprovider WHERE dataProviderName='OUTSTANDING_BILL_STU_REM_ON_DAY_S2_RCPNT');

UPDATE sql_dtprovider SET sqlQuery=
"SELECT
bh.id AS ID,
SUM(bfprs.balanceAmount) as OUTSTANDING_AMT,
bh.studentId,
p.emailId AS EMAIL_ID,
p.mobileNumber AS MOBILE_NO,
p.mobileCountryCode AS MOBILE_CODE,
p.printName AS PRINT_NAME,
p.firstName AS FIRST_NAME,
p.lastName AS LAST_NAME,
sal.salutationName AS SALUTATION_NAME,
bh.billNo AS BILL_NO,
DATE_FORMAT(bh.billingDate, '%d-%m-%Y') AS BILL_DATE,
DATE_FORMAT(bh.dueDate, '%d-%m-%Y') AS BILL_DUE_DATE,
T6.displayName AS ACADEMY_NAME,
ml.code as LANGUAGE_KEY,
(select GROUP_CONCAT(DISTINCT deviceTokenId) from fire_base_persons_info where fire_base_persons_info.userId=bh.studentId) AS DEVICE_ID
FROM
bill_header bh
JOIN
bill_fee_plan_rule_stage bfprs ON bfprs.billId = bh.id
JOIN
students s ON s.userId = bh.studentId
JOIN
persons p ON p.id = s.personId
LEFT JOIN
salutations sal ON sal.id = p.salutationId
LEFT JOIN
academy_location T6 ON T6.id = bh.academyLocationId
LEFT JOIN
multi_language ml on ml.id=p.correspondence_language
WHERE
bh.id IN (namedParams)
AND bh.billStatus NOT IN ('CANCELLED' , 'SETTLED') group by bh.id"
WHERE dataProviderId=@studentReminderOnDueDay2;

END IF; 

IF NOT EXISTS ((SELECT id FROM dtprovider WHERE dataProviderName='OUTSTANDING_BILL_STUDENT_REM_ON_3DAY_PRIOR_RCPNT')) THEN 

SET @studentRemOnThreeDayPrior=(SELECT id FROM dtprovider WHERE dataProviderName='OUTSTANDING_BILL_STUDENT_REM_ON_3DAY_PRIOR_RCPNT');

UPDATE sql_dtprovider SET sqlQuery=
"SELECT
bh.id AS ID,
SUM(bfprs.balanceAmount) as OUTSTANDING_AMT,
bh.studentId,
p.emailId AS EMAIL_ID,
p.mobileNumber AS MOBILE_NO,
p.mobileCountryCode AS MOBILE_CODE,
p.printName AS PRINT_NAME,
p.firstName AS FIRST_NAME,
p.lastName AS LAST_NAME,
sal.salutationName AS SALUTATION_NAME,
bh.billNo AS BILL_NO,
DATE_FORMAT(bh.billingDate, '%d-%m-%Y') AS BILL_DATE,
DATE_FORMAT(bh.dueDate, '%d-%m-%Y') AS BILL_DUE_DATE,
T6.displayName AS ACADEMY_NAME,
(select GROUP_CONCAT(DISTINCT deviceTokenId) from fire_base_persons_info where fire_base_persons_info.userId=bh.studentId) AS DEVICE_ID,
ml.code as LANGUAGE_KEY
FROM
bill_header bh
JOIN
bill_fee_plan_rule_stage bfprs ON bfprs.billId = bh.id
JOIN
students s ON s.userId = bh.studentId
JOIN
persons p ON p.id = s.personId
LEFT JOIN
salutations sal ON sal.id = p.salutationId
LEFT JOIN
academy_location T6 ON T6.id = bh.academyLocationId
LEFT JOIN
multi_language ml on ml.id=p.correspondence_language
WHERE
bh.id IN (namedParams)
AND bh.billStatus NOT IN ('CANCELLED' , 'SETTLED') group by bh.id"
WHERE dataProviderId=@studentRemOnThreeDayPrior;

END IF; 

IF NOT EXISTS ((SELECT id FROM dtprovider WHERE dataProviderName='OUTSTANDING_BILL_STUDENT_REM_RCPNT')) THEN 

SET @outstandingBillStudentReminder=(SELECT id FROM dtprovider WHERE dataProviderName='OUTSTANDING_BILL_STUDENT_REM_RCPNT');

UPDATE sql_dtprovider SET sqlQuery=
"SELECT
bh.id AS ID,
SUM(bfprs.balanceAmount) as OUTSTANDING_AMT,
bh.studentId,
p.emailId AS EMAIL_ID,
p.mobileNumber AS MOBILE_NO,
p.mobileCountryCode AS MOBILE_CODE,
p.printName AS PRINT_NAME,
p.firstName AS FIRST_NAME,
p.lastName AS LAST_NAME,
sal.salutationName AS SALUTATION_NAME,
bh.billNo AS BILL_NO,
DATE_FORMAT(bh.billingDate, '%d-%m-%Y') AS BILL_DATE,
DATE_FORMAT(bh.dueDate, '%d-%m-%Y') AS BILL_DUE_DATE,
T6.displayName AS ACADEMY_NAME,
(select GROUP_CONCAT(DISTINCT deviceTokenId) from fire_base_persons_info where fire_base_persons_info.userId=bh.studentId) AS DEVICE_ID,
ml.code as LANGUAGE_KEY
FROM
bill_header bh
JOIN
bill_fee_plan_rule_stage bfprs ON bfprs.billId = bh.id
JOIN
students s ON s.userId = bh.studentId
JOIN
persons p ON p.id = s.personId
LEFT JOIN
salutations sal ON sal.id = p.salutationId
LEFT JOIN
academy_location T6 ON T6.id = bh.academyLocationId
LEFT JOIN
multi_language ml on ml.id=p.correspondence_language
WHERE
bh.id IN (namedParams)
AND bh.billStatus NOT IN ('CANCELLED' , 'SETTLED') group by bh.id"
WHERE dataProviderId=@outstandingBillStudentReminder;

END IF; 
SET SQL_SAFE_UPDATES=1;
END $$
CALL V20230411161554__Update_OutstandingBillReminderRecipient () $$
DROP PROCEDURE IF EXISTS V20230411161554__Update_OutstandingBillReminderRecipient $$
DELIMITER ;