DELIMITER $$
DROP PROCEDURE IF EXISTS V20230509160110__Insert_ExamGradeBookStudentEvent $$
CREATE PROCEDURE V20230509160110__Insert_ExamGradeBookStudentEvent()
BEGIN

IF NOT EXISTS ((select id from system_msg_event where code='PUBLISH_GRADE_BOOK_FOR_STUDENTS')) THEN 

SET @parentcategoryId=(select id from msg_category where code="EXAMINATION");
SET @msgcategoryId=(SELECT MAX(id) FROM msg_category);
INSERT INTO `msg_category` (`id`,`parentCategory`,`code`) VALUES (@msgcategoryId+1,@parentcategoryId,'PUBLISH_GRADE_BOOK_FOR_STUDENTS');

SET @systemmsgeventId=(SELECT MAX(id) FROM system_msg_event);
SET @msgSubCategoryId=(SELECT id FROM msg_category WHERE `code`='PUBLISH_GRADE_BOOK_FOR_STUDENTS');

INSERT INTO `system_msg_event` 
(`id`, `msgConfigLevelId`, `msgSubCategoryId`, `code`, `displayCode`, `eventType`, `whetherRepetationApplicable`, `whetherInitiationRuleApplicable`, `whetherScheduledEvent`, `whetherMsgScopeApplicable`, `whetherImplicitDistributionList`, `whetherDistributionRuleApplicable`, `whetherCommonMsgTemplate`, `description`) 
VALUES (@systemmsgeventId+1, '1', @msgSubCategoryId, 'PUBLISH_GRADE_BOOK_FOR_STUDENTS', 'Publish GradeBook For Students', 'SYSTEM', 0, 0, 0, 0, 1, 0, 0, 'Email GradeBook For Students');

SET @sysmsgevtdefaultconfId=(SELECT MAX(id) FROM sys_msg_evt_default_conf);
INSERT INTO `sys_msg_evt_default_conf` (`id`, `systemMsgEventId`, `msgTemplateConfigId`, `initiationRuleProviderId`, `sendingPriority`) 
VALUES (@sysmsgevtdefaultconfId+1, @systemmsgeventId+1, NULL, NULL, 'IMMEDIATE');

SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='CONTEXT_RECORD_ID');
INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1, @sysmsgevtdefaultconfId+1, @msgScopeParamId);

SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='EVENT_TRIGGER_DATE');
INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1, @sysmsgevtdefaultconfId+1, @msgScopeParamId);

SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='CONFIG_LEVEL_VALUE');
INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1, @sysmsgevtdefaultconfId+1, @msgScopeParamId);

SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='ACADEMY_LOCATION_IDS');
INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1	, @sysmsgevtdefaultconfId+1, @msgScopeParamId);

SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='EXTRA_PARAMS');
INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1	, @sysmsgevtdefaultconfId+1, @msgScopeParamId);

-- Template data provider for the Appointment

SET @dtproviderId=(SELECT MAX(id) FROM dtprovider);
INSERT INTO `dtprovider` (`id`, `dataProviderName`, `dataProviderType`) VALUES (@dtproviderId+1, 'PUBLISH_GRADE_BOOK_FOR_STUDENTS_DL', 'SQL');

SET @dtproviderId=(SELECT MAX(id) FROM dtprovider);
INSERT INTO `dtprovider` (`id`, `dataProviderName`, `dataProviderType`) VALUES (@dtproviderId+1, 'PUBLISH_GRADE_BOOK_FOR_STUDENTS_RECIPIENT', 'SQL');


-- Create Recipient Type 

SET @msgRecipientId=(SELECT MAX(id) FROM msg_recipient_type);
SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='PUBLISH_GRADE_BOOK_FOR_STUDENTS_RECIPIENT');
INSERT INTO `msg_recipient_type` (`id`, `recipientDataProviderId`, `code`) VALUES (@msgRecipientId+1, @dtproviderId, 'PUBLISH_GRADE_BOOK_FOR_STUDENTS_RECIPIENT');


SET @sysmsgevtrcptdefaultconfId=(SELECT MAX(id) FROM `sys_msg_evtrcpt_default_conf`);
SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='PUBLISH_GRADE_BOOK_FOR_STUDENTS_DL');
SET @recipientTypeId=(SELECT id FROM `msg_recipient_type` WHERE `code`='PUBLISH_GRADE_BOOK_FOR_STUDENTS_RECIPIENT');
INSERT INTO `sys_msg_evtrcpt_default_conf` (`id`, `sysMsgEvtDefaultConfId`, `distrListProviderId`, `distrRuleProviderId`, `recipientTypeId`) 
VALUES (@sysmsgevtrcptdefaultconfId+1, @sysmsgevtdefaultconfId+1, @dtproviderId, NULL, @recipientTypeId);



-- Setting the query for the Applicant distribution list

SET @sqlDtproviderId=(SELECT MAX(id) FROM `sql_dtprovider`);
SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='PUBLISH_GRADE_BOOK_FOR_STUDENTS_DL');
INSERT INTO `sql_dtprovider` (`id`, `dataProviderId`, `sqlQuery`, `jsonString`) VALUES (@sqlDtproviderId+1,@dtproviderId,
"SELECT T1.id as USER_ID FROM
        	 `examination_report_document` T1 
		      WHERE T1.id IN (namedParams)",NULL);


-- Setting the query for the User Recipient

SET @sqlDtproviderId=(SELECT MAX(id) FROM `sql_dtprovider`);
SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='PUBLISH_GRADE_BOOK_FOR_STUDENTS_RECIPIENT');
INSERT INTO `sql_dtprovider` (`id`, `dataProviderId`, `sqlQuery`, `jsonString`) VALUES (@sqlDtproviderId+1,@dtproviderId,
'SELECT 
  T12.`id` AS ID,
       T3.`firstName` AS FIRST_NAME,
       T3.`printName` AS STUDENT_PRINT_NAME,
       T3.`mobileNumber` AS MOBILE_NO,
       T3.`emailId` AS EMAIL_ID,
       T7.`academyName` AS ACADEMY_NAME,
       T7.`locationName` AS LOCATION_NAME,
       T8.`programName` AS PROGRAM_NAME,
       T10.`batchName` AS BATCH_NAME,
       T11.`programPeriodName` AS PERIOD_NAME
   FROM
   examination_report_document T12 
    left join 
       admission T1 on T12.admissionId=T1.id
             left join
            students as T2 on T2.userId=T1.studentId
            left join 
            persons as T3 on T3.id=T2.personId
            left join 
            academy_location T7 on T7.id=T1.academyLocationId
            left join 
            programs T8 on T8.id=T1.programId
  		   left join 
            prog_batch_period_config T11 on T11.id=T12.periodId
            left join
            batches T10 on T10.id=T11.programBatchId
   WHERE
       T12.id IN (namedParams)  limit 1','{
     "id": 1,
     "searchResultViewColumns": [
 		 {
             "id": 1,
             "value": "printName",
             "resultKey": "STUDENT_PRINT_NAME",
             "displayCode": "",
             "displayOrder": 0
         },
         {
             "id": 2,
             "value": "mobileNumber",
             "resultKey": "MOBILE_NO",
             "displayCode": "",
             "displayOrder": 1  
 	    },
        {
             "id": 3,
             "value": "emailId",
             "resultKey": "EMAIL_ID",
             "displayCode": "",
             "displayOrder": 2
         },
         {
            "id": 3,
             "value": "programName",
             "resultKey": "PROGRAM_NAME",
             "displayCode": "",
             "displayOrder": 3
 	    },
 	    {
            "id": 4,
             "value": "batchName",
             "resultKey": "BATCH_NAME",
             "displayCode": "",
             "displayOrder": 5
 	    },
        {
            "id": 5,
             "value": "programPeriodName",
             "resultKey": "PERIOD_NAME",
             "displayCode": "",
             "displayOrder": 6
 	    },
 	    
 	     {
             "id": 6,
             "value": "academyName",
             "resultKey": "ACADEMY_NAME",
             "displayCode": "",
             "displayOrder": 7
         },
         {
             "id": 7,
             "value": "locationName",
             "resultKey": "LOCATION_NAME",
             "displayCode": "",
             "displayOrder": 7
         }
 	
 ]}');


SET @msgtemplateId=(SELECT MAX(id) FROM msg_template);
SET @sysMsgEventId=(SELECT id FROM system_msg_event where code='PUBLISH_GRADE_BOOK_FOR_STUDENTS');


SET @msgtemplateconfigId=(SELECT MAX(id) FROM msg_template_config);
SET @msgSubCategoryId=(SELECT id FROM `msg_category` WHERE `code`='PUBLISH_GRADE_BOOK_FOR_STUDENTS');
SET @recipientTypeId=(SELECT id FROM `msg_recipient_type` WHERE `code`='PUBLISH_GRADE_BOOK_FOR_STUDENTS_RECIPIENT');
SET @msgMessageTypeId=(SELECT id FROM `msg_message_type` WHERE `code`='Notifications');

INSERT INTO `msg_template_config` (`id`, `code`, `msgSubCategoryId`, `sysMsgEventId`, `recipientTypeId`, `msgMessageTypeId`, `templateDataProviderId`, `templateConfigType`, `templateConfigName`, `whetherBulkMesaging`, `approvalRequired`, `approverId`, `whetherStaticMsg`, `status`, `availableForAdhocMsg`, `academyLocationId`, `authorName`, `authorId`,`templatelanguageValue`,`whetherEnabled`) 
VALUES(@msgtemplateconfigId+1,'Publish GradeBook For Students Template',@msgSubCategoryId,@sysMsgEventId,@recipientTypeId,@msgMessageTypeId,NULL,NULL,'Publish GradeBook For Students Template',NULL,'',NULL,'','APPROVED','','1','System Admin','1','English',b'1');


INSERT INTO `msg_template` (`id`, `msgTemplateConfigId`, `msgDeliveryModeId`, `subjectLine`, `msgContent`) 
VALUES (@msgtemplateId+1,@msgtemplateconfigId+1,'1','Publish GradeBook For Students','<html>
<head>
	<title></title>
</head>
<body>
<p><span style="color: rgb(23, 43, 77); font-family: -apple-system, BlinkMacSystemFont, &quot;Segoe UI&quot;, Roboto, Oxygen, Ubuntu, &quot;Fira Sans&quot;, &quot;Droid Sans&quot;, &quot;Helvetica Neue&quot;, sans-serif; font-size: 14px; letter-spacing: -0.07px; white-space: pre-line; background-color: rgb(235, 236, 240);">Dear $recipientData[&quot;STUDENT_PRINT_NAME&quot;],</span></p>

<p><span style="color: rgb(23, 43, 77); font-family: -apple-system, BlinkMacSystemFont, &quot;Segoe UI&quot;, Roboto, Oxygen, Ubuntu, &quot;Fira Sans&quot;, &quot;Droid Sans&quot;, &quot;Helvetica Neue&quot;, sans-serif; font-size: 14px; letter-spacing: -0.07px; white-space: pre-line; background-color: rgb(235, 236, 240);">Congratulations! You Have cleared the Exam $recipientData[&quot;PROGRAM_NAME&quot;].&nbsp;</span></p>

<p><span style="color: rgb(23, 43, 77); font-family: -apple-system, BlinkMacSystemFont, &quot;Segoe UI&quot;, Roboto, Oxygen, Ubuntu, &quot;Fira Sans&quot;, &quot;Droid Sans&quot;, &quot;Helvetica Neue&quot;, sans-serif; font-size: 14px; letter-spacing: -0.07px; white-space: pre-line; background-color: rgb(235, 236, 240);">A detailed GradeBook for $recipientData[&quot;PROGRAM_NAME&quot;] $recipientData[&quot;BATCH_NAME&quot;] $recipientData[&quot;PERIOD_NAME&quot;] is attached below. </span></p>

<p><span style="color: rgb(23, 43, 77); font-family: -apple-system, BlinkMacSystemFont, &quot;Segoe UI&quot;, Roboto, Oxygen, Ubuntu, &quot;Fira Sans&quot;, &quot;Droid Sans&quot;, &quot;Helvetica Neue&quot;, sans-serif; font-size: 14px; letter-spacing: -0.07px; white-space: pre-line; background-color: rgb(235, 236, 240);">Thanks</span></p>
</body>
</html>
');

INSERT INTO `msg_template` (`id`, `msgTemplateConfigId`, `msgDeliveryModeId`, `subjectLine`, `msgContent`) 
VALUES (@msgtemplateId+2,@msgtemplateconfigId+1,'2','Publish GradeBook For Students','<html>
<head>
	<title></title>
</head>
<body>
<p><span style="color: rgb(23, 43, 77); font-family: -apple-system, BlinkMacSystemFont, &quot;Segoe UI&quot;, Roboto, Oxygen, Ubuntu, &quot;Fira Sans&quot;, &quot;Droid Sans&quot;, &quot;Helvetica Neue&quot;, sans-serif; font-size: 14px; letter-spacing: -0.07px; white-space: pre-line; background-color: rgb(235, 236, 240);">Dear $recipientData[&quot;STUDENT_PRINT_NAME&quot;],</span></p>

<p><span style="color: rgb(23, 43, 77); font-family: -apple-system, BlinkMacSystemFont, &quot;Segoe UI&quot;, Roboto, Oxygen, Ubuntu, &quot;Fira Sans&quot;, &quot;Droid Sans&quot;, &quot;Helvetica Neue&quot;, sans-serif; font-size: 14px; letter-spacing: -0.07px; white-space: pre-line; background-color: rgb(235, 236, 240);">Congratulations! You Have cleared the Exam $recipientData[&quot;PROGRAM_NAME&quot;].&nbsp;</span></p>

<p><span style="color: rgb(23, 43, 77); font-family: -apple-system, BlinkMacSystemFont, &quot;Segoe UI&quot;, Roboto, Oxygen, Ubuntu, &quot;Fira Sans&quot;, &quot;Droid Sans&quot;, &quot;Helvetica Neue&quot;, sans-serif; font-size: 14px; letter-spacing: -0.07px; white-space: pre-line; background-color: rgb(235, 236, 240);">A detailed GradeBook for $recipientData[&quot;PROGRAM_NAME&quot;] $recipientData[&quot;BATCH_NAME&quot;] $recipientData[&quot;PERIOD_NAME&quot;] is attached below. </span></p>

<p><span style="color: rgb(23, 43, 77); font-family: -apple-system, BlinkMacSystemFont, &quot;Segoe UI&quot;, Roboto, Oxygen, Ubuntu, &quot;Fira Sans&quot;, &quot;Droid Sans&quot;, &quot;Helvetica Neue&quot;, sans-serif; font-size: 14px; letter-spacing: -0.07px; white-space: pre-line; background-color: rgb(235, 236, 240);">Thanks</span></p>
</body>
</html>
');

INSERT INTO `msg_template` (`id`, `msgTemplateConfigId`, `msgDeliveryModeId`, `subjectLine`, `msgContent`) 
VALUES(@msgtemplateId+3,@msgtemplateconfigId+1,'4','Publish GradeBook For Students','<html>
<head>
	<title></title>
</head>
<body>
<p><span style="color: rgb(23, 43, 77); font-family: -apple-system, BlinkMacSystemFont, &quot;Segoe UI&quot;, Roboto, Oxygen, Ubuntu, &quot;Fira Sans&quot;, &quot;Droid Sans&quot;, &quot;Helvetica Neue&quot;, sans-serif; font-size: 14px; letter-spacing: -0.07px; white-space: pre-line; background-color: rgb(235, 236, 240);">Dear $recipientData[&quot;STUDENT_PRINT_NAME&quot;],</span></p>

<p><span style="color: rgb(23, 43, 77); font-family: -apple-system, BlinkMacSystemFont, &quot;Segoe UI&quot;, Roboto, Oxygen, Ubuntu, &quot;Fira Sans&quot;, &quot;Droid Sans&quot;, &quot;Helvetica Neue&quot;, sans-serif; font-size: 14px; letter-spacing: -0.07px; white-space: pre-line; background-color: rgb(235, 236, 240);">Congratulations! You Have cleared the Exam $recipientData[&quot;PROGRAM_NAME&quot;].&nbsp;</span></p>

<p><span style="color: rgb(23, 43, 77); font-family: -apple-system, BlinkMacSystemFont, &quot;Segoe UI&quot;, Roboto, Oxygen, Ubuntu, &quot;Fira Sans&quot;, &quot;Droid Sans&quot;, &quot;Helvetica Neue&quot;, sans-serif; font-size: 14px; letter-spacing: -0.07px; white-space: pre-line; background-color: rgb(235, 236, 240);">A detailed GradeBook for $recipientData[&quot;PROGRAM_NAME&quot;] $recipientData[&quot;BATCH_NAME&quot;] $recipientData[&quot;PERIOD_NAME&quot;] is attached below. </span></p>

<p><span style="color: rgb(23, 43, 77); font-family: -apple-system, BlinkMacSystemFont, &quot;Segoe UI&quot;, Roboto, Oxygen, Ubuntu, &quot;Fira Sans&quot;, &quot;Droid Sans&quot;, &quot;Helvetica Neue&quot;, sans-serif; font-size: 14px; letter-spacing: -0.07px; white-space: pre-line; background-color: rgb(235, 236, 240);">Thanks</span></p>
</body>
</html>');
END IF; 

END $$
CALL V20230509160110__Insert_ExamGradeBookStudentEvent() $$
DROP PROCEDURE IF EXISTS V20230509160110__Insert_ExamGradeBookStudentEvent $$
DELIMITER ;