DELIMITER $$
DROP PROCEDURE IF EXISTS V20230725105436__Insert_ApplicantPermitDataGrid $$
CREATE PROCEDURE V20230725105436__Insert_ApplicantPermitDataGrid()
BEGIN

IF NOT EXISTS ((select * from data_grid where gridName='Academia.view.personinfo.common.personalinfo.ApplicantPermitDetailGrid'  and portalId=1)) THEN 
INSERT INTO `data_grid`
(`gridName`,`portalId`,`jsonObject`,`lastUpdate`,`lastUpdatedBy`)
VALUES
('Academia.view.personinfo.common.personalinfo.ApplicantPermitDetailGrid',1,
'[{"id":null,"columnName":"PERMIT_TYPE","dataIndex":"permitType.value","columnVisibility":"SHOW","sequence":1,"mandatory":true},
  {"id":null,"columnName":"COUNTRY_OF_ISSUE","dataIndex":"countryOfIssue.value","columnVisibility":"SHOW","sequence":2,"mandatory":false},
  {"id":null,"columnName":"CANTON_OF_ISSUE","dataIndex":"cantonOfIssue.value","columnVisibility":"SHOW","sequence":3,"mandatory":false},
  {"id":null,"columnName":"IS_PERMIT_WITH_FAMILY","dataIndex":"isPermitWithFamily","columnVisibility":"SHOW","sequence":4,"mandatory":false},
  {"id":null,"columnName":"PERMIT_START_DATE","dataIndex":"permitStartDate","columnVisibility":"SHOW","sequence":5,"mandatory":false},
  {"id":null,"columnName":"PERMIT_EXPIRATION_DATE","dataIndex":"permitExpirationDate","columnVisibility":"SHOW","sequence":6,"mandatory":false},
  {"id":null,"columnName":"PERMIT_CANCELLATION_DATE","dataIndex":"permitCancellationDate","columnVisibility":"HIDE","sequence":7,"mandatory":false},
  {"id":null,"columnName":"DATE_OF_DEPARTURE_ANNOUNCEMENT_TO_MIGRATION_OFFICE","dataIndex":"dateOfDepartureAnnouncement","columnVisibility":"HIDE","sequence":8,"mandatory":false},
  {"id":null,"columnName":"REASON_FOR_PERMIT_CANCELLATION","dataIndex":"reasonForPermitCancellation","columnVisibility":"HIDE","sequence":9,"mandatory":false},
  {"id":null,"columnName":"DATE_SUBMITTED_TO_AUTHORITIES","dataIndex":"dateSubmittedToAuthorities","columnVisibility":"HIDE","sequence":10,"mandatory":false},
  {"id":null,"columnName":"METHOD_OF_SUBMISSION","dataIndex":"methodOfSubmission.value","columnVisibility":"HIDE","sequence":11,"mandatory":false},
  {"id":null,"columnName":"DATE_ISSUED","dataIndex":"dateIssued","columnVisibility":"HIDE","sequence":12,"mandatory":false},
  {"id":null,"columnName":"DATE_COLLECTED","dataIndex":"dateCollected","columnVisibility":"HIDE","sequence":13,"mandatory":false},
  {"id":null,"columnName":"IS_PRIMARY","dataIndex":"isPrimary","columnVisibility":"HIDE","sequence":14,"mandatory":false},
  {"id":null,"columnName":"UPLOADED_DOCUMENTS","dataIndex":"permitDetailDocuments","columnVisibility":"SHOW","sequence":15,"mandatory":false},
  {"id":null,"columnName":"UPLOADED_URLS","dataIndex":"permitDetailUrlDocuments","columnVisibility":"SHOW","sequence":16,"mandatory":false}]'
  ,now(),1);
END IF; 

IF NOT EXISTS ((SELECT * FROM ui_translation WHERE keyName = 'STUDENT_PERMIT' and  objectName ='TRANSLATIONS')) THEN 
INSERT INTO ui_translation (objectName,keyName,defaultValue,customerDefineValue,afriLanguage,vietLanguage,lastUpdate,lastUpdatedBy)
VALUES ('TRANSLATIONS','STUDENT_PERMIT',"Student Permit","Student Permit","Studentepermit","Giấy phép sinh viên",now(),1);
END IF;	

IF NOT EXISTS ((SELECT * FROM ui_translation WHERE keyName = 'APPLICANT_PERMIT' and  objectName ='TRANSLATIONS')) THEN 
INSERT INTO ui_translation (objectName,keyName,defaultValue,customerDefineValue,afriLanguage,vietLanguage,lastUpdate,lastUpdatedBy)
VALUES ('TRANSLATIONS','APPLICANT_PERMIT',"Applicant Permit","Applicant Permit","Aansoeker Permit","Giấy phép của người nộp đơn",now(),1);
END IF;	

END $$
CALL V20230725105436__Insert_ApplicantPermitDataGrid() $$
DROP PROCEDURE IF EXISTS V20230725105436__Insert_ApplicantPermitDataGrid $$
DELIMITER ;