DELIMITER $$
DROP PROCEDURE IF EXISTS V20230728144653__Create_ApplicantHealthDocument $$
CREATE PROCEDURE V20230728144653__Create_ApplicantHealthDocument()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='applicant_health_document')) THEN 
CREATE TABLE `applicant_health_document`(  
  `id`BIGINT(20) NOT NULL AUTO_INCREMENT,
  `healthId` BIGINT(20) NOT NULL,
  `documentId` BIGINT(20) NOT NULL,
  `lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `lastUpdatedBy` BIGINT(20) NOT NULL,
  PRIMARY KEY (id),
  CONSTRAINT `ApplicantHealthDocument_FK` FOREIGN KEY (`healthId`) REFERENCES applicant_health_details(`id`),
  CONSTRAINT `ApplicantHealthDocument_documentId_FK` FOREIGN KEY (`documentId`) REFERENCES documents(`id`),
  CONSTRAINT `ApplicantHealthDocument_lastUpdatedBy_FK` FOREIGN KEY (`lastUpdatedBy`) REFERENCES users(`id`))
  ENGINE=InnoDB DEFAULT CHARSET=utf8;
END IF; 

END $$
CALL V20230728144653__Create_ApplicantHealthDocument () $$ 
DROP PROCEDURE IF EXISTS V20230728144653__Create_ApplicantHealthDocument $$ 
DELIMITER ;