DELIMITER $$
DROP PROCEDURE IF EXISTS V20230817142741__CreateHostelOfferDetail $$
CREATE PROCEDURE V20230817142741__CreateHostelOfferDetail()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='hostel_offer_detail')) THEN 
CREATE TABLE `hostel_offer_detail` (
`id` bigint(20) NOT NULL AUTO_INCREMENT,
`applicantPersonId` bigint(20) NOT NULL,
`documentTemplateConfId` bigint(20) DEFAULT NULL,
`hostelStudentCategoryId` bigint(20) DEFAULT NULL,
`reservationCategoryId` bigint(20) DEFAULT NULL,
`hostelFeeAmount` double(20,2) DEFAULT NULL,
`locationId` bigint(20) DEFAULT NULL,
`offerLetterExpiryDate` date DEFAULT NULL,
`cancellationReason` text DEFAULT NULL,
`offerLetterIssueDate` date DEFAULT NULL,
`academyLocationId` bigint(20) NOT NULL,
`lastUpdatedBy` bigint(20) NOT NULL,
`lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,

PRIMARY KEY (`id`),
FOREIGN KEY (`applicantPersonId`)REFERENCES `applicant_person`(`id`),
FOREIGN KEY (`hostelStudentCategoryId`)REFERENCES `hostel_student_category`(`id`),
FOREIGN KEY (`reservationCategoryId`)REFERENCES `reservation_category`(`id`),
FOREIGN KEY (`locationId`)REFERENCES `locations`(`id`),
FOREIGN KEY (`academyLocationId`)REFERENCES `academy_location`(`id`),
FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users`(`id`)
);
	
END IF; 

IF NOT EXISTS ((SELECT * FROM `import_utility_master` WHERE screenName = 'Bulk Hostel Applicant Status Update' and  code ='Bulk Hostel Applicant Status Update')) THEN 
INSERT INTO `import_utility_master` (`screenName`, `fileDirectory`, `code`, `lastUpdatedBy`)
VALUES ('Bulk Hostel Applicant Status Update', 'hostelApplication/HostelApplicationUpdate', 'Bulk Hostel Applicant Status Update', '1');
END IF; 

END $$
CALL V20230817142741__CreateHostelOfferDetail () $$ 
DROP PROCEDURE IF EXISTS V20230817142741__CreateHostelOfferDetail $$ 
DELIMITER ;