DELIMITER $$
DROP PROCEDURE IF EXISTS V20230817151023__Insert_New4to7_Velocity $$
CREATE PROCEDURE V20230817151023__Insert_New4to7_Velocity()
BEGIN
	
set @reportTypeTempId = (select max(id) from report_type where typeName='Mark Sheet' );	

IF NOT EXISTS ((SELECT * FROM `report_template` WHERE `templateCode` = 'GIS_4_7_REPORT_CARD_WITH_SYMBOLS')) THEN 
INSERT INTO `report_template` (`reportTypeId`, `templateCode`, `templateName`, `imageLocation`, `jasperFileLocation`, `templateType`, `documentTypes`, `whetherDefault`, `headerJasperFileLocation`, `footerJasperFileLocation`, `repeatHeaderOnAllPages`, `repeatFooterOnAllPages`, `bodyJasperFileLocation`, `defaultHeaderLogo`) 
VALUES (@reportTypeTempId, 'GIS_4_7_REPORT_CARD_WITH_SYMBOLS', 'GIS 4-7 Report Card with Symbols', 'GIS_4_7_REPORT_CARD_WITH_SYMBOLS.png', 'GIS_4_7_REPORT_CARD_WITH_SYMBOLS_CommonReport.jasper', 'EVALUATION_TYPE', 'All', '1', 'FooterBlank.jasper', 'FooterBlank.jasper', '1', '1', 'GIS_4_7_REPORT_CARD_WITH_SYMBOLS.jasper', 'AcademiaLogo.png');
END IF;

set @tempId = (select max(id) from report_template where templateCode='GIS_4_7_REPORT_CARD_WITH_SYMBOLS' and templateName='GIS 4-7 Report Card with Symbols');

IF NOT EXISTS (SELECT * FROM report_template_translations WHERE reportTemplateId = @tempId AND keyValue='TRANS_TRANSCRIPT') THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@tempId, 'TRANS_TRANSCRIPT', 'Progress Report', '1', now());
END IF;

IF NOT EXISTS (SELECT * FROM report_template_translations WHERE reportTemplateId = @tempId AND keyValue='TRANS_STUDENT_NAME') THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@tempId, 'TRANS_STUDENT_NAME', 'Student Name', '1', now());
END IF;

IF NOT EXISTS (SELECT * FROM report_template_translations WHERE reportTemplateId = @tempId AND keyValue='TRANS_STUDENT_ID') THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@tempId, 'TRANS_STUDENT_ID', 'Student ID', '1', now());
END IF;

IF NOT EXISTS (SELECT * FROM report_template_translations WHERE reportTemplateId = @tempId AND keyValue='TRANS_GRADE') THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@tempId, 'TRANS_GRADE', 'Grade', '1', now());
END IF;

IF NOT EXISTS (SELECT * FROM report_template_translations WHERE reportTemplateId = @tempId AND keyValue='TRANS_STUDENT_NAME1') THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@tempId, 'TRANS_STUDENT_NAME1', 'Student Name:', '1', now());
END IF;

IF NOT EXISTS (SELECT * FROM report_template_translations WHERE reportTemplateId = @tempId AND keyValue='TRANS_DAYS_ABSENT') THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@tempId, 'TRANS_DAYS_ABSENT', 'Days Absent:', '1', now());
END IF;

IF NOT EXISTS (SELECT * FROM report_template_translations WHERE reportTemplateId = @tempId AND keyValue='TRANS_CYCLE_START_DATE') THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@tempId, 'TRANS_CYCLE_START_DATE', 'Cycle Start Date:', '1', now());
END IF;

IF NOT EXISTS (SELECT * FROM report_template_translations WHERE reportTemplateId = @tempId AND keyValue='TRANS_CYCLE_END_DATE') THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@tempId, 'TRANS_CYCLE_END_DATE', 'Cycle End Date:', '1', now());
END IF;

IF NOT EXISTS (SELECT * FROM report_template_translations WHERE reportTemplateId = @tempId AND keyValue='TRANS_REPORT_CARD') THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@tempId, 'TRANS_REPORT_CARD', 'Report Card', '1', now());
END IF;

IF NOT EXISTS (SELECT * FROM report_template_translations WHERE reportTemplateId = @tempId AND keyValue='TRANS_SUBJECTS') THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@tempId, 'TRANS_SUBJECTS', 'Subjects', '1', now());
END IF;

IF NOT EXISTS (SELECT * FROM report_template_translations WHERE reportTemplateId = @tempId AND keyValue='TRANS_CYCLE1') THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@tempId, 'TRANS_CYCLE1', 'Cycle 1', '1', now());
END IF;

IF NOT EXISTS (SELECT * FROM report_template_translations WHERE reportTemplateId = @tempId AND keyValue='TRANS_CYCLE2') THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@tempId, 'TRANS_CYCLE2', 'Cycle 2', '1', now());
END IF;

IF NOT EXISTS (SELECT * FROM report_template_translations WHERE reportTemplateId = @tempId AND keyValue='TRANS_CYCLE3') THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@tempId, 'TRANS_CYCLE3', 'Cycle 3', '1', now());
END IF;

IF NOT EXISTS (SELECT * FROM report_template_translations WHERE reportTemplateId = @tempId AND keyValue='TRANS_PROMOTION_RESULT') THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@tempId, 'TRANS_PROMOTION_RESULT', 'Promotion Result', '1', now());
END IF;

IF NOT EXISTS (SELECT * FROM report_template_translations WHERE reportTemplateId = @tempId AND keyValue='TRANS_CAT1') THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@tempId, 'TRANS_CAT1', 'CAT 1', '1', now());
END IF;

IF NOT EXISTS (SELECT * FROM report_template_translations WHERE reportTemplateId = @tempId AND keyValue='TRANS_CAT2') THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@tempId, 'TRANS_CAT2', 'CAT 2', '1', now());
END IF;

IF NOT EXISTS (SELECT * FROM report_template_translations WHERE reportTemplateId = @tempId AND keyValue='TRANS_AVG') THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@tempId, 'TRANS_AVG', 'Avg', '1', now());
END IF;

IF NOT EXISTS (SELECT * FROM report_template_translations WHERE reportTemplateId = @tempId AND keyValue='TRANS_SYMBOL') THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@tempId, 'TRANS_SYMBOL', 'Symbol', '1', now());
END IF;

IF NOT EXISTS (SELECT * FROM report_template_translations WHERE reportTemplateId = @tempId AND keyValue='TRANS_GRADE_AVERAGE') THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@tempId, 'TRANS_GRADE_AVERAGE', 'Grade Average', '1', now());
END IF;

IF NOT EXISTS (SELECT * FROM report_template_translations WHERE reportTemplateId = @tempId AND keyValue='TRANS_EXAM') THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@tempId, 'TRANS_EXAM', 'EXAM', '1', now());
END IF;

IF NOT EXISTS (SELECT * FROM report_template_translations WHERE reportTemplateId = @tempId AND keyValue='TRANS_AVERAGE') THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@tempId, 'TRANS_AVERAGE', 'Average', '1', now());
END IF;

IF NOT EXISTS (SELECT * FROM report_template_translations WHERE reportTemplateId = @tempId AND keyValue='TRANS_PROMOTION_STATUS') THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@tempId, 'TRANS_PROMOTION_STATUS', 'Promotion Status', '1', now());
END IF;

IF NOT EXISTS (SELECT * FROM report_template_translations WHERE reportTemplateId = @tempId AND keyValue='TRANS_LEVEL') THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@tempId, 'TRANS_LEVEL', 'Level', '1', now());
END IF;

IF NOT EXISTS (SELECT * FROM report_template_translations WHERE reportTemplateId = @tempId AND keyValue='TRANS_DATE') THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@tempId, 'TRANS_DATE', 'Date', '1', now());
END IF;

IF NOT EXISTS (SELECT * FROM report_template_translations WHERE reportTemplateId = @tempId AND keyValue='TRANS_PRINCIPAL') THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@tempId, 'TRANS_PRINCIPAL', 'Principal', '1', now());
END IF;

IF NOT EXISTS (SELECT * FROM report_template_translations WHERE reportTemplateId = @tempId AND keyValue='TRANS_TEACHER') THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@tempId, 'TRANS_TEACHER', 'Teacher:', '1', now());
END IF;

IF NOT EXISTS (SELECT * FROM report_template_translations WHERE reportTemplateId = @tempId AND keyValue='TRANS_REPORT_CARD1') THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@tempId, 'TRANS_REPORT_CARD1', 'Report Card', '1', now());
END IF;

IF NOT EXISTS (SELECT * FROM report_template_translations WHERE reportTemplateId = @tempId AND keyValue='TRANS_COMMENT') THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@tempId, 'TRANS_COMMENT', 'Comment', '1', now());
END IF;

IF NOT EXISTS (SELECT * FROM report_template_translations WHERE reportTemplateId = @tempId AND keyValue='TRANS_PERCENTAGE') THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@tempId, 'TRANS_PERCENTAGE', 'Percentage', '1', now());
END IF;

IF NOT EXISTS (SELECT * FROM report_template_translations WHERE reportTemplateId = @tempId AND keyValue='TRANS_SYMBOL1') THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@tempId, 'TRANS_SYMBOL1', 'Symbol', '1', now());
END IF;

IF NOT EXISTS (SELECT * FROM report_template_translations WHERE reportTemplateId = @tempId AND keyValue='TRANS_M1') THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@tempId, 'TRANS_M1', '90% and above', '1', now());
END IF;

IF NOT EXISTS (SELECT * FROM report_template_translations WHERE reportTemplateId = @tempId AND keyValue='TRANS_M2') THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@tempId, 'TRANS_M2', '80% - 89%', '1', now());
END IF;

IF NOT EXISTS (SELECT * FROM report_template_translations WHERE reportTemplateId = @tempId AND keyValue='TRANS_M3') THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@tempId, 'TRANS_M3', '70% - 79%', '1', now());
END IF;

IF NOT EXISTS (SELECT * FROM report_template_translations WHERE reportTemplateId = @tempId AND keyValue='TRANS_M4') THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@tempId, 'TRANS_M4', '60% - 69%', '1', now());
END IF;

IF NOT EXISTS (SELECT * FROM report_template_translations WHERE reportTemplateId = @tempId AND keyValue='TRANS_M5') THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@tempId, 'TRANS_M5', '50% - 59%', '1', now());
END IF;

IF NOT EXISTS (SELECT * FROM report_template_translations WHERE reportTemplateId = @tempId AND keyValue='TRANS_M6') THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@tempId, 'TRANS_M6', '40% - 49%', '1', now());
END IF;

IF NOT EXISTS (SELECT * FROM report_template_translations WHERE reportTemplateId = @tempId AND keyValue='TRANS_M7') THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@tempId, 'TRANS_M7', '30% - 39%', '1', now());
END IF;

IF NOT EXISTS (SELECT * FROM report_template_translations WHERE reportTemplateId = @tempId AND keyValue='TRANS_M8') THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@tempId, 'TRANS_M8', '20% - 29%', '1', now());
END IF;

IF NOT EXISTS (SELECT * FROM report_template_translations WHERE reportTemplateId = @tempId AND keyValue='TRANS_M9') THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@tempId, 'TRANS_M9', 'Below 20%', '1', now());
END IF;

IF NOT EXISTS (SELECT * FROM report_template_translations WHERE reportTemplateId = @tempId AND keyValue='TRANS_G1') THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@tempId, 'TRANS_G1', 'A*', '1', now());
END IF;

IF NOT EXISTS (SELECT * FROM report_template_translations WHERE reportTemplateId = @tempId AND keyValue='TRANS_G2') THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@tempId, 'TRANS_G2', 'A', '1', now());
END IF;

IF NOT EXISTS (SELECT * FROM report_template_translations WHERE reportTemplateId = @tempId AND keyValue='TRANS_G3') THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@tempId, 'TRANS_G3', 'B', '1', now());
END IF;

IF NOT EXISTS (SELECT * FROM report_template_translations WHERE reportTemplateId = @tempId AND keyValue='TRANS_G4') THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@tempId, 'TRANS_G4', 'C', '1', now());
END IF;

IF NOT EXISTS (SELECT * FROM report_template_translations WHERE reportTemplateId = @tempId AND keyValue='TRANS_G5') THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@tempId, 'TRANS_G5', 'D', '1', now());
END IF;

IF NOT EXISTS (SELECT * FROM report_template_translations WHERE reportTemplateId = @tempId AND keyValue='TRANS_G6') THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@tempId, 'TRANS_G6', 'E', '1', now());
END IF;

IF NOT EXISTS (SELECT * FROM report_template_translations WHERE reportTemplateId = @tempId AND keyValue='TRANS_G7') THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@tempId, 'TRANS_G7', 'F', '1', now());
END IF;

IF NOT EXISTS (SELECT * FROM report_template_translations WHERE reportTemplateId = @tempId AND keyValue='TRANS_G8') THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@tempId, 'TRANS_G8', 'G', '1', now());
END IF;

IF NOT EXISTS (SELECT * FROM report_template_translations WHERE reportTemplateId = @tempId AND keyValue='TRANS_G9') THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@tempId, 'TRANS_G9', 'H', '1', now());
END IF;

IF NOT EXISTS (SELECT * FROM report_template_translations WHERE reportTemplateId = @tempId AND keyValue='TRANS_GRADE_MASTER') THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@tempId, 'TRANS_GRADE_MASTER', 'Grade Master', '1', now());
END IF;

END $$
CALL V20230817151023__Insert_New4to7_Velocity() $$
DROP PROCEDURE IF EXISTS V20230817151023__Insert_New4to7_Velocity $$
DELIMITER ;