DELIMITER $$
DROP PROCEDURE IF EXISTS V20231011130237__Insert_UITranslationsCriteriaJson $$
CREATE PROCEDURE V20231011130237__Insert_UITranslationsCriteriaJson()
BEGIN

IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE objectName = 'TRANSLATIONS' and keyName = 'INVALID_JSON_PRE_REQ')) THEN 
INSERT INTO `ui_translation` (`objectName`, `keyName`, `defaultValue`, `customerDefineValue`,`afriLanguage`,`vietLanguage`,`lastUpdate`,`lastUpdatedBy`)
VALUES ('TRANSLATIONS', 'INVALID_JSON_PRE_REQ', 'Invalid json for pre-requisites additional criteria', 'Invalid json for pre-requisites additional criteria',
'Ongeldige json vir bykomende kriteria vir voorvereistes','JSON không hợp lệ đối với các tiêu chí bổ sung cần thiết trước',now(),1);
END IF;

IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE objectName = 'TRANSLATIONS' and keyName = 'INVALID_JSON_CO_REQ')) THEN 
INSERT INTO `ui_translation` (`objectName`, `keyName`, `defaultValue`, `customerDefineValue`,`afriLanguage`,`vietLanguage`,`lastUpdate`,`lastUpdatedBy`)
VALUES ('TRANSLATIONS', 'INVALID_JSON_CO_REQ', 'Invalid json for co-requisites additional criteria', 'Invalid json for co-requisites additional criteria',
'Ongeldige json vir medevereistes bykomende kriteria','JSON không hợp lệ cho các tiêu chí bổ sung đồng điều kiện tiên quyết',now(),1);
END IF;

IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE objectName = 'TRANSLATIONS' and keyName = 'COREQ_CONDITION_NOT_MATCHED')) THEN 
INSERT INTO `ui_translation` (`objectName`, `keyName`, `defaultValue`, `customerDefineValue`,`afriLanguage`,`vietLanguage`,`lastUpdate`,`lastUpdatedBy`)
VALUES ('TRANSLATIONS', 'COREQ_CONDITION_NOT_MATCHED', 'Co-requisites condition not matched for:', 'Co-requisites condition not matched for:',
'Medevereistes-voorwaarde stem nie ooreen nie vir:','Điều kiện đồng điều kiện không phù hợp với:',now(),1);
END IF;

IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE objectName = 'TRANSLATIONS' and keyName = 'PREREQ_CONDITION_NOT_MATCHED')) THEN 
INSERT INTO `ui_translation` (`objectName`, `keyName`, `defaultValue`, `customerDefineValue`,`afriLanguage`,`vietLanguage`,`lastUpdate`,`lastUpdatedBy`)
VALUES ('TRANSLATIONS', 'PREREQ_CONDITION_NOT_MATCHED', 'Pre-requisites condition not matched for:', 'Pre-requisites condition not matched for:',
'Voorvereistes voorwaarde nie ooreenstem nie vir:','Điều kiện tiên quyết không phù hợp với:',now(),1);
END IF;

END $$
CALL V20231011130237__Insert_UITranslationsCriteriaJson() $$
DROP PROCEDURE IF EXISTS V20231011130237__Insert_UITranslationsCriteriaJson $$
DELIMITER ;