DELIMITER $$
DROP PROCEDURE IF EXISTS V20231121173955__Update_AttendanceDayWiseAbsentPushMother $$
CREATE PROCEDURE V20231121173955__Update_AttendanceDayWiseAbsentPushMother()
BEGIN
SET SQL_SAFE_UPDATES=0;
IF EXISTS ((select * from dtprovider d WHERE d.dataProviderName='ATTENDANCE_DAY_WISE_PARENT_ABSENT_PUSH_MOTHER_RCPNT')) THEN 
SET @dtproviderRCPNT=(select id from dtprovider d WHERE d.dataProviderName='ATTENDANCE_DAY_WISE_PARENT_ABSENT_PUSH_MOTHER_RCPNT');
UPDATE `sql_dtprovider` SET `sqlQuery`=
"SELECT 
    T1.id as ID,
	T9.salutationName AS SALUTATION_NAME,
    T7.printName AS PRINT_NAME,
    T7.firstName AS FIRST_NAME,
    T7.middleName AS MIDDLE_NAME,
    T7.lastName AS LAST_NAME,
    T7.emailId AS EMAIL_ID,
	T7.alternateEmailId as ALTERNATE_EMAIL_ID,
    T7.mobileNumber AS MOBILE_NO,
    T7.mobileCountryCode AS MOBILE_CODE,
    T2.itemValue as ATTENDANCE_MARKING_TYPE,
   -- T2.attendanceStatus AS ATTENDANCE_STATUS,
    T5.printName AS STUDENT_PRINT_NAME,
    T5.firstName AS STUDENT_FIRST_NAME,
    T5.middleName AS STUDENT_MIDDLE_NAME,
    T5.lastName AS STUDENT_LAST_NAME,
    T8.academyName AS ACADEMY_NAME,
    T8.locationName AS LOCATION_NAME,
    T8.displayName AS ACADEMY_NAME_LOCATION,
    ml.code as LANGUAGE_KEY,
	(select group_concat(distinct deviceTokenId) from fire_base_persons_info f where T12.id = f.userId)  AS DEVICE_ID,
	DATE_FORMAT(T10.dateOfAttendance, '%d-%m-%Y') AS SESSION_DATE,    
    (case when (T2.itemValue = 'Present' and T2.attendanceStatus = 'PRESENT') then CONCAT(UCASE(LEFT(T2.attendanceStatus, 1)), LCASE(SUBSTRING(T2.attendanceStatus, 2)))
     when (T2.itemValue = 'Absent' and T2.attendanceStatus = 'ABSENT') then CONCAT(UCASE(LEFT(T2.attendanceStatus, 1)), LCASE(SUBSTRING(T2.attendanceStatus, 2)))
    else CONCAT(T2.itemValue, '/', CONCAT(UCASE(LEFT(T2.attendanceStatus, 1)), LCASE(SUBSTRING(T2.attendanceStatus, 2))))
    end) AS ATTENDANCE_STATUS
FROM
    student_program_attendance_details as T1
     LEFT JOIN
    attendance_marking_type AS T2 ON T2.id = T1.attendanceMarkingTypeId
     LEFT JOIN
    admission AS T3 ON T3.id = T1.admissionId
	 LEFT JOIN
    students AS T4 ON T4.userId = T3.studentId
     LEFT JOIN
    persons AS T5 ON T5.id = T4.personId
	 LEFT JOIN
    person_relationships as T6 ON T6.personId = T5.id
	 LEFT JOIN
    persons AS T7 ON T7.id = T6.relatedPersonId
    LEFT JOIN
    academy_location T8 ON T8.id = T3.academyLocationId
    LEFT JOIN
    salutations AS T9 ON T9.id = T7.salutationId
    LEFT JOIN
    student_program_attendance AS T10 ON T10.id = T1.attendanceId
    LEFT JOIN
	multi_language ml on ml.id=T5.correspondence_language
	LEFT JOIN
    parents T11 ON T11.personId = T7.id
        LEFT JOIN
    users T12 ON T12.id = T11.userID
WHERE (T7.isDeceased is null OR T7.isDeceased=FALSE) AND 
T1.id IN (namedParams) AND T2.attendanceStatus = 'ABSENT' AND T7.isMobUseForCommunication = TRUE  AND T6.relationship = 'MOTHER' AND T6.whetherDeleted = false"

WHERE  dataProviderId =@dtproviderRCPNT;

END IF; 
SET SQL_SAFE_UPDATES=1;
END $$
CALL V20231121173955__Update_AttendanceDayWiseAbsentPushMother () $$
DROP PROCEDURE IF EXISTS V20231121173955__Update_AttendanceDayWiseAbsentPushMother $$
DELIMITER ;