DELIMITER $$
DROP PROCEDURE IF EXISTS V20240125161620__Create_debit_order_receipt $$
CREATE PROCEDURE V20240125161620__Create_debit_order_receipt()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='debit_order_receipt')) THEN 
CREATE TABLE  `debit_order_receipt` (
  `id` BIGINT(20) NOT NULL AUTO_INCREMENT,  
  `amount` double(20,2) NOT NULL DEFAULT 0.0,
  `narration` VARCHAR(500) NULL,
  `isAutoSettle` TINYINT NULL DEFAULT 1,
  `costCentreId`BIGINT(20) NULL,
  `currencyId` BIGINT(20) NULL,
  `studentPaymentPlanEnrollment` BIGINT(20) NOT NULL,
  `paymentPlanSchedule` BIGINT(20) NOT NULL,
  `receiptHeaderId` BIGINT(20) NULL,
  `debitOrderStatus` VARCHAR(45) NULL,
   `lastUpdatedBy` bigint(20) NOT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  CONSTRAINT `costCentreId`  FOREIGN KEY (costCentreId) REFERENCES cost_centre(id),
    CONSTRAINT `paymentPlanSchedule`    FOREIGN KEY (paymentPlanSchedule)    REFERENCES payment_plan_schedule(id),
    CONSTRAINT `studentPaymentPlanEnrollment`    FOREIGN KEY (studentPaymentPlanEnrollment)    REFERENCES student_payment_plan_enrollment(id),
    CONSTRAINT `receiptHeaderId`    FOREIGN KEY (receiptHeaderId)    REFERENCES receipt_header(id), 
    CONSTRAINT `currencyId`    FOREIGN KEY (currencyId)    REFERENCES `currency`(id),
	   FOREIGN KEY (lastUpdatedBy)    REFERENCES `users` (`id`));
END IF; 

END $$
CALL V20240125161620__Create_debit_order_receipt () $$ 
DROP PROCEDURE IF EXISTS V20240125161620__Create_debit_order_receipt $$ 
DELIMITER ;