DELIMITER $$
DROP PROCEDURE IF EXISTS V20240222141534__Alter_Country_Add_Column_Phone_Number $$
CREATE PROCEDURE V20240222141534__Alter_Country_Add_Column_Phone_Number()
BEGIN

IF EXISTS (SELECT * FROM information_schema.Columns WHERE table_schema=DATABASE() AND table_name='country') THEN 
IF NOT EXISTS (SELECT * FROM information_schema.Columns WHERE table_schema=DATABASE() AND table_name='country' and column_name in ('phMinLength','phMaxLength')) THEN
ALTER TABLE country ADD COLUMN `phMinDigit` TINYINT(1) DEFAULT 6;
ALTER TABLE country ADD COLUMN `phMaxDigit` TINYINT(1) DEFAULT 10;
END IF;
END IF; 

-- Get country standard master id
SET @standardMasterId=(SELECT id FROM standard_master where tableName='country');

SET @ItemsMaxId=(SELECT MAX(id) FROM standard_master_items);
INSERT INTO standard_master_items(id, dbFieldName, fieldLabel, standardMasterId, fieldType, diaplayOrder, whetherForeignKey, whetherShortCode, whetherReadOnly, wheherNullable, lastUpdatedBy, lastUpdate) 
VALUES (@ItemsMaxId+1, 'phMaxDigit', 'MAXIMUM_DIGIT_PHONE', @standardMasterId, 'Number', '7', 0, 0, 0, 1, '1', SYSDATE());


SET @ItemsMaxId=(SELECT MAX(id) FROM standard_master_items);
INSERT INTO standard_master_items(id, dbFieldName, fieldLabel, standardMasterId, fieldType, diaplayOrder, whetherForeignKey, whetherShortCode, whetherReadOnly, wheherNullable, lastUpdatedBy, lastUpdate) 
VALUES (@ItemsMaxId+1, 'phMinDigit', 'MINIMUM_DIGIT_PHONE', @standardMasterId, 'Number', '8', 0, 0, 0, 1, '1', SYSDATE());

END $$
CALL V20240222141534__Alter_Country_Add_Column_Phone_Number() $$
DROP PROCEDURE IF EXISTS V20240222141534__Alter_Country_Add_Column_Phone_Number $$
DELIMITER ;