DELIMITER $$
DROP PROCEDURE IF EXISTS V20240222163534__Create_Create_BatchSubHoldCategory $$
CREATE PROCEDURE V20240222163534__Create_Create_BatchSubHoldCategory()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='batch_sub_hold_category')) THEN 
CREATE TABLE `batch_sub_hold_category` (
  `id` BIGINT(20) NOT NULL AUTO_INCREMENT,
  `subHoldCatId` BIGINT(20) NOT NULL,
  `batchId` BIGINT(20) NOT NULL,
  `lastUpdatedBy` BIGINT(20) NOT NULL,
  `lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  INDEX `fk_batch_sub_hold_category_subHoldCatId_idx` (`subHoldCatId` ASC),
  INDEX `fk_batch_sub_hold_category_batchId_idx` (`batchId` ASC),
  INDEX `fk_batch_sub_hold_category_lastUpdateBy_idx` (`lastUpdatedBy` ASC),
  CONSTRAINT `fk_batch_sub_hold_category_subHoldCatId`
    FOREIGN KEY (`subHoldCatId`)
    REFERENCES `manage_sub_hold_category` (`id`)
    ON DELETE RESTRICT
    ON UPDATE RESTRICT,
  CONSTRAINT `fk_batch_sub_hold_category_batchId`
    FOREIGN KEY (`batchId`)
    REFERENCES `batches` (`id`)
    ON DELETE RESTRICT
    ON UPDATE RESTRICT,
  CONSTRAINT `fk_batch_sub_hold_category_lastUpdateBy`
    FOREIGN KEY (`lastUpdatedBy`)
    REFERENCES `users` (`id`)
    ON DELETE RESTRICT
    ON UPDATE RESTRICT);
END IF; 

END $$
CALL V20240222163534__Create_Create_BatchSubHoldCategory () $$ 
DROP PROCEDURE IF EXISTS V20240222163534__Create_Create_BatchSubHoldCategory $$ 
DELIMITER ;