DELIMITER $$
DROP PROCEDURE IF EXISTS V20240315174341__Alter_ViewForCustomReport $$
CREATE PROCEDURE V20240315174341__Alter_ViewForCustomReport()
BEGIN

CREATE OR REPLACE 
VIEW `course_view` AS
    select 
    	`cou`.`id` AS `id`,
        `cou`.`courseName` AS `Name`,
        `cou`.`courseCode` AS `Code`,
        `dept`.`deptName` AS `DepartmentName`,
        `dept`.`shortCode` AS `DepartmentCode`,
        `cou`.`courseCredits` AS `Credit`
    from
        (`courses` `cou`
        join `department` `dept` ON ((`dept`.`id` = `cou`.`departmentId`)));

CREATE OR REPLACE  
VIEW `department_view` AS
    select 
  		`dept`.`id` AS `id`,	
        `dept`.`deptName` AS `Name`,
        `dept`.`shortCode` AS `Code`,
        `dept`.`deptType` AS `Category`
    from
        `department` `dept`;

CREATE OR REPLACE 
VIEW `faculty_view` AS
    select 
  		`usr`.`id` AS `id`,	
        `usr`.`code` AS `RegistrationId`,
        `usr`.`printName` AS `Name`,
        `per`.`emailId` AS `Email`,
        `per`.`mobileNumber` AS `Phone`,
        `dpt`.`deptName` AS `DepartmentName`,
        `dpt`.`shortCode` AS `DepartmentCode`,
        `per`.`gender` AS `Gender`
    from
        (((`staffs` `stf`
        join `users` `usr` ON ((`usr`.`id` = `stf`.`userId`)))
        join `persons` `per` ON ((`per`.`id` = `stf`.`personId`)))
        join `department` `dpt` ON ((`dpt`.`id` = `stf`.`departmentId`)))
    where
        ((`stf`.`whetherFaculty` = 1)
            and (`usr`.`status` = 1)
            and (`usr`.`whetherDeleted` = 0));

CREATE OR REPLACE  
VIEW `program_view` AS
    select     
  		`prg`.`id` AS `id`,	
        `prg`.`programName` AS `Name`,
        `prg`.`programCode` AS `Code`,
        `dpt`.`deptName` AS `DepartmentName`,
        `dpt`.`shortCode` AS `DepartmentCode`,
        `bch`.`batchName` AS `Batch`,
        `bch`.`startDate` AS `StartDate`,
        `bch`.`tillDate` AS `TillDate`,
        `ppt`.`typeName` AS `System`
    from
        (((`programs` `prg`
        join `batches` `bch` ON ((`bch`.`programId` = `prg`.`id`)))
        join `program_period_type` `ppt` ON ((`ppt`.`id` = `bch`.`programPeriodTypeId`)))
        join `department` `dpt` ON ((`prg`.`programDepartmentId` = `dpt`.`id`)))
    where
        (`prg`.`status` = 'O');

CREATE OR REPLACE 
VIEW `section_view` AS
    select 
        `sec`.`id` AS `id`,
        `sec`.`sectionCode` AS `Name`,
        `sec`.`sectionCode` AS `Code`,
        `ity`.`itemCode` AS `BatchYear`,
        `prg`.`programName` AS `ProgramCode`
    from
        ((((`sections` `sec`
        join `prog_batch_period_config` `per` ON ((`per`.`id` = `sec`.`periodId`)))
        join `batches` `bch` ON ((`bch`.`id` = `per`.`programBatchId`)))
        join `intake_year` `ity` ON ((`ity`.`id` = `bch`.`intakeYearId`)))
        join `programs` `prg` ON ((`prg`.`id` = `bch`.`programId`)));


END $$
CALL V20240315174341__Alter_ViewForCustomReport() $$
DROP PROCEDURE IF EXISTS V20240315174341__Alter_ViewForCustomReport $$
DELIMITER ;