DELIMITER $$
DROP PROCEDURE IF EXISTS V20240319184639__Insert_Expenditure_Organization $$
CREATE PROCEDURE V20240319184639__Insert_Expenditure_Organization()
BEGIN

SET @currentTimeStamp = (SELECT CURRENT_TIMESTAMP);
SET @standardMasterMaxId=(SELECT MAX(id) FROM standard_master);

IF NOT EXISTS ((SELECT * FROM standard_master WHERE masterName = 'EXPENDITURE_ORGANIZATION_CSM')) THEN 
INSERT INTO `standard_master`(`id`,`childMaster`,`tableName`,`masterName`,`moduleName`,`filterCode`,`whetherChild`,`whetherParent`, `droolsAgenda`,`lastUpdatedBy`,`lastUpdate`) 
VALUES (@standardMasterMaxId+1, NULL,'expenditure_organization_csm','EXPENDITURE_ORGANIZATION_CSM','Fees & Payments','COMMON_MASTER',0,0,NULL,1,@currentTimeStamp);
END IF; 


IF  EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='standard_master_items')) THEN 
SET @standardMasterId=(select id from standard_master where tableName = 'expenditure_organization_csm');
INSERT INTO `standard_master_items` (`dbFieldName`,`fieldLabel`,`standardMasterId`,`fieldType`,`emunType`,`diaplayOrder`,`whetherForeignKey`,`fkTable`,`fkFieldName`,`fkDisplayField`,`whetherShortCode`,`whetherReadOnly`,`wheherNullable`,`validationType`,`maxLength`,`minLength`,`lastUpdatedBy`,`lastUpdate`)
VALUES ('itemCode','ITEM_CODE',@standardMasterId,'Varchar',NULL,1,0,NULL,NULL,NULL,0,0,0,NULL,NULL,NULL,1,now());

INSERT INTO `standard_master_items` (`dbFieldName`,`fieldLabel`,`standardMasterId`,`fieldType`,`emunType`,`diaplayOrder`,`whetherForeignKey`,`fkTable`,`fkFieldName`,`fkDisplayField`,`whetherShortCode`,`whetherReadOnly`,`wheherNullable`,`validationType`,`maxLength`,`minLength`,`lastUpdatedBy`,`lastUpdate`)
VALUES ('itemValue','ITEM_VALUE',@standardMasterId,'Varchar',NULL,2,0,NULL,NULL,NULL,0,0,0,NULL,NULL,NULL,1,now());

END IF; 

-- translations

IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE objectName = 'masterNames' and keyName = 'EXPENDITURE_ORGANIZATION_CSM')) THEN 
INSERT INTO `ui_translation` (`objectName`, `keyName`, `defaultValue`, `customerDefineValue`,`afriLanguage`,`vietLanguage`,`lastUpdate`,`lastUpdatedBy`)
VALUES ('masterNames', 'EXPENDITURE_ORGANIZATION_CSM', 'Expenditure Organization', 'Expenditure Organization','Uitgawes Organisasie','Tổ chức chi tiêu',now(),1);
END IF;

END $$
CALL V20240319184639__Insert_Expenditure_Organization() $$
DROP PROCEDURE IF EXISTS V20240319184639__Insert_Expenditure_Organization $$
DELIMITER ;