DELIMITER $$
DROP PROCEDURE IF EXISTS V20240501115336__Insert_Email_Certificate_Debarment_Event $$
CREATE PROCEDURE V20240501115336__Insert_Email_Certificate_Debarment_Event()
BEGIN

IF NOT EXISTS ((SELECT * FROM msg_category WHERE `code`='EMAIL_CERTIFICATE_DEBARMENT')) THEN
 SET @parentcategoryId=(SELECT id FROM msg_category WHERE `code`='STUDENT');
 SET @msgcategoryId=(SELECT MAX(id) FROM msg_category);
 INSERT INTO `msg_category` (`id`,`parentCategory`,`code`) VALUES (@msgcategoryId+1,@parentcategoryId,'EMAIL_CERTIFICATE_DEBARMENT');
 
 
 SET @systemmsgeventId=(SELECT MAX(id) FROM system_msg_event);
 SET @msgSubCategoryId=(SELECT id FROM msg_category WHERE `code`='EMAIL_CERTIFICATE_DEBARMENT');
 INSERT INTO `system_msg_event`
 (`id`, `msgConfigLevelId`, `msgSubCategoryId`, `code`, `displayCode`, `eventType`, `whetherRepetationApplicable`, `whetherInitiationRuleApplicable`, `whetherScheduledEvent`, `whetherMsgScopeApplicable`, `whetherImplicitDistributionList`, `whetherDistributionRuleApplicable`, `whetherCommonMsgTemplate`, `description`)
 VALUES (@systemmsgeventId+1, '2', @msgSubCategoryId, 'EMAIL_CERTIFICATE_DEBARMENT', 'Email Certificate Debarment', 'SYSTEM', 0, 0, 0, 0, 1, 0, 0, 'Email Certificate Debarment');
 
 
 SET @sysmsgevtdefaultconfId=(SELECT MAX(id) FROM sys_msg_evt_default_conf);
 INSERT INTO `sys_msg_evt_default_conf` (`id`, `systemMsgEventId`, `msgTemplateConfigId`, `initiationRuleProviderId`, `sendingPriority`)
 VALUES (@sysmsgevtdefaultconfId+1, @systemmsgeventId+1, NULL, NULL, 'IMMEDIATE');
 
 SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
 SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='CONTEXT_RECORD_ID');
 INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1, @sysmsgevtdefaultconfId+1, @msgScopeParamId);
 
 SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
 SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='EVENT_TRIGGER_DATE');
 INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1, @sysmsgevtdefaultconfId+1, @msgScopeParamId);
 
 SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
 SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='CONFIG_LEVEL_VALUE');
 INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1, @sysmsgevtdefaultconfId+1, @msgScopeParamId);
 
 SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
 SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='ACADEMY_LOCATION_IDS');
 INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1	, @sysmsgevtdefaultconfId+1, @msgScopeParamId);
 
 SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
 SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='EXTRA_PARAMS');
 INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1	, @sysmsgevtdefaultconfId+1, @msgScopeParamId);
 
  -- Template data provider for the Event
  
 SET @dtproviderId=(SELECT MAX(id) FROM dtprovider);
 INSERT INTO `dtprovider` (`id`, `dataProviderName`, `dataProviderType`) VALUES (@dtproviderId+1, 'EMAIL_CERTIFICATE_DEBARMENT_DL', 'SQL');
 
 SET @dtproviderId=(SELECT MAX(id) FROM dtprovider);
 INSERT INTO `dtprovider` (`id`, `dataProviderName`, `dataProviderType`) VALUES (@dtproviderId+1, 'EMAIL_CERTIFICATE_DEBARMENT_RECIPIENT', 'SQL');
 
  -- Create Recipient Type
  
   SET @msgRecipientId=(SELECT MAX(id) FROM msg_recipient_type);
 SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='EMAIL_CERTIFICATE_DEBARMENT_RECIPIENT');
 INSERT INTO `msg_recipient_type` (`id`, `recipientDataProviderId`, `code`) VALUES (@msgRecipientId+1, @dtproviderId, 'EMAIL_CERTIFICATE_DEBARMENT_RECIPIENT');
 
 
 SET @sysmsgevtrcptdefaultconfId=(SELECT MAX(id) FROM `sys_msg_evtrcpt_default_conf`);
 SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='EMAIL_CERTIFICATE_DEBARMENT_DL');
 SET @recipientTypeId=(SELECT id FROM `msg_recipient_type` WHERE `code`='EMAIL_CERTIFICATE_DEBARMENT_RECIPIENT');
 INSERT INTO `sys_msg_evtrcpt_default_conf` (`id`, `sysMsgEvtDefaultConfId`, `distrListProviderId`, `distrRuleProviderId`, `recipientTypeId`)
 VALUES (@sysmsgevtrcptdefaultconfId+1, @sysmsgevtdefaultconfId+1, @dtproviderId, NULL, @recipientTypeId);
  
  
 -- Setting the query for the Applicant distribution list
 
 SET @sqlDtproviderId=(SELECT MAX(id) FROM `sql_dtprovider`);
 SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='EMAIL_CERTIFICATE_DEBARMENT_DL');
 INSERT INTO `sql_dtprovider` (`id`, `dataProviderId`, `sqlQuery`, `jsonString`) VALUES (@sqlDtproviderId+1,@dtproviderId,"SELECT DISTINCT T1.id AS USER_ID FROM completions T1 WHERE T1.id IN (namedParams)",NULL);
 
 -- Setting the query for the User Recipient
 
 SET @sqlDtproviderId=(SELECT MAX(id) FROM `sql_dtprovider`);
 SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='EMAIL_CERTIFICATE_DEBARMENT_RECIPIENT');
 INSERT INTO sql_dtprovider (id, dataProviderId, sqlQuery, jsonString) VALUES (@sqlDtproviderId+1,@dtproviderId,
 "SELECT
    T1.id AS ID,
    T3.remarks AS DEBARMENT_REMARK,
	T3.requestDate AS REQUEST_DATE,
	T4.fromDate AS DEBARMENT_FROM_DATE,
	T4.toDate AS DEBARMENT_TO_DATE,
    GROUP_CONCAT(' ',
        T6.itemValue,
        ' - ',
        T5.reasonRemark) AS DEBARMENT_REASON_AND_REMARK,
    T7.printName AS INITIATED_BY,
    T9.code AS STUDENT_ID,
    T9.printName AS STUDENT_NAME,
    T12.salutationName AS SALUTATION,
    T14.code AS APPLICANT_CODE,
    T15.printName AS APPLICANT_PRINT_NAME,
    T16.programCode AS PROGRAMCODE,
    T16.programNameToBePrint AS PROGRAM_PRINT_NAME,
    CONCAT(T17.deptName, ' / ', T17.shortCode) AS PROGRAM_DEPARTMENT_NAME,
    CONCAT(T18.deptName, ' / ', T18.shortCode) AS PROGRAM_SUB_DEPARTMENT_NAME,
    T19.startDate AS INTAKE_START_DATE,
    T19.tillDate AS INTAKE_END_DATE,
    T20.groupName AS PROGRAM_GROUP_NAME,
    T8.admissionDate AS ADMISSION_DATE,
    T8.code AS ADMISSION_ID,
    T11.mobileNumber AS MOBILE_NO,
    T11.emailId AS EMAIL_ID,
    DATE(NOW()) AS TODAYS_DATE,
    T11.nationalID AS IDENTITY_NUMBER,
    T11.initials AS INITIALS,
    T11.alternateEmailId AS ALTERNATE_EMAIL_ID,
    T21.itemValue AS MODE_OF_DELIVERY,
    T22.itemValue AS STUDENT_GENDER,
	CONCAT(T23.displayName, ',', T24.locationName) AS ACADEMY_LOCATION_NAME,
    T26.addressText AS ACADEMY_ADDRESS,
    T28.countryName AS ACADEMY_COUNTRY_NAME,
    T29.countryRegionName AS ACADEMY_REGION_NAME,
    T27.cityName AS ACADEMY_CITY_NAME,
    T26.postalCode AS ACADEMY_POSTALCODE,
    T26.phoneNo AS ACADEMY_PHONE_NUMBER,
    T26.cellNo AS ACADEMY_MOBILE_NUMBER,
    T26.primaryeEmailId AS ACADEMY_EMAILID,
    T30.orgName AS ORGANIZATION_NAME,
    T32.addressText AS ORGANIZATION_ADDRESS,
    T34.countryName AS ORGANIZATION_COUNTRY_NAME,
    T35.countryRegionName AS ORGANIZATION_REGION_NAME,
    T33.cityName AS ORGANIZATION_CITY_NAME,
    T32.postalCode AS Organization_postalCode,
    T32.phoneNo AS ORGANIZATION_PHONE_NUMBER,
    T32.cellNo AS ORGANIZATION_MOBILE_NUMBER,
    T32.primaryeEmailId AS ORGANIZATION_EMAILID,
    T32.alternateEmailId AS ORGANIZATION_ALTERNATE_EMAILID,
	T36.printName AS PERIOD_PRINT_NAME,
	T11.firstName AS FIRST_NAME
FROM
    completions T1
        LEFT OUTER JOIN
    temp_terminations T2 ON T1.id = T2.completionId
        LEFT OUTER JOIN
    service_requests T3 ON T2.serviceRequestId = T3.id
        LEFT OUTER JOIN
    debarment_request_details T4 ON T4.serviceRequestId = T3.id
        LEFT OUTER JOIN
    debarment_request_multiple_reason T5 ON T5.debarmentRequestDetailId = T4.id
        LEFT OUTER JOIN
    debarment_reasons T6 ON T6.id = T5.debarmentReasonId
        LEFT OUTER JOIN
    users T7 ON T7.id = T4.initiatedBy
        LEFT OUTER JOIN
    admission T8 ON T8.id = T4.admissionId
        LEFT OUTER JOIN
    users T9 ON T9.id = T8.studentId
        LEFT OUTER JOIN
    students T10 ON T9.id = T10.userId
        LEFT OUTER JOIN
    persons T11 ON T11.id = T10.personId
        LEFT OUTER JOIN
    salutations T12 ON T12.id = T11.salutationId
        LEFT OUTER JOIN
    application_program T13 ON T13.id = T8.applicationProgramId
        LEFT OUTER JOIN
    application T14 ON T14.id = T13.applicationId
        LEFT OUTER JOIN
    applicant_person T15 ON T15.id = T14.applicantPersonId
        LEFT OUTER JOIN
    programs T16 ON T16.id = T1.programId
        LEFT OUTER JOIN
    department T17 ON T17.id = T16.programDepartmentId
        LEFT OUTER JOIN
    department T18 ON T18.id = T16.subDepartmentId
        LEFT OUTER JOIN
    batches T19 ON T19.id = T1.batchId
        LEFT OUTER JOIN
    program_group T20 ON T20.id = T16.programGroupId
        LEFT OUTER JOIN
    mode_of_delivery T21 ON T21.id = T16.modeOfDeliveryId
        LEFT OUTER JOIN
    gender T22 ON T22.id = T11.genderId
        LEFT OUTER JOIN
    academy_location T23 ON T23.id = T8.academyLocationId
        LEFT OUTER JOIN
    locations T24 ON T24.id = T23.locationId
        LEFT OUTER JOIN
    location_addresses T25 ON T25.locationId = T24.id
        LEFT OUTER JOIN
    address T26 ON T26.id = T25.addressId
        LEFT OUTER JOIN
    city T27 ON T27.id = T26.cityId
        LEFT OUTER JOIN
    country T28 ON T28.id = T27.countryId
        LEFT OUTER JOIN
    country_region T29 ON T29.id = T27.id
        LEFT OUTER JOIN
    organizations T30 ON T30.id = T24.organizationId
        LEFT OUTER JOIN
    organization_addresses T31 ON T31.organizationId = T30.id
        LEFT OUTER JOIN
    address T32 ON T32.id = T31.addressId
        LEFT OUTER JOIN
    city T33 ON T33.id = T32.cityId
        LEFT OUTER JOIN
    country T34 ON T34.id = T33.countryId
        LEFT OUTER JOIN
    country_region T35 ON T35.id = T33.id
	    LEFT OUTER JOIN
	prog_batch_period_config T36 ON T36.id = T8.programBatchPeriodConfigId
	
WHERE
    T32.addressTypeId = 1 and
    T1.id IN (namedParams);",'{
     "id": 1,
     "searchResultViewColumns": [
         {
            "id": 1,
            "value": "orgName",
            "resultKey": "ORGANIZATION_NAME",
            "displayCode": "",
            "displayOrder": 0
        },        
        {
            "id": 2,
            "value": "addressText",
            "resultKey": "ORGANIZATION_ADDRESS",
            "displayCode": "",
            "displayOrder": 1
        },       
        {
            "id": 3,
            "value": "countryName",
            "resultKey": "ORGANIZATION_COUNTRY_NAME",
            "displayCode": "",
            "displayOrder": 2
        },       
        {
            "id": 4,
            "value": "countryRegionName",
            "resultKey": "ORGANIZATION_REGION_NAME",
            "displayCode": "",
            "displayOrder": 3
        },
		
		{
            "id": 5,
            "value": "cityName",
            "resultKey": "ORGANIZATION_CITY_NAME",
            "displayCode": "",
            "displayOrder": 4
        },
		{
            "id": 6,
            "value": "postalCode",
            "resultKey": "Organization_postalCode",
            "displayCode": "",
            "displayOrder": 5
        },
		{
            "id": 7,
            "value": "phoneNo",
            "resultKey": "ORGANIZATION_PHONE_NUMBER",
            "displayCode": "",
            "displayOrder": 6
        },{
            "id": 8,
            "value": "cellNo",
            "resultKey": "ORGANIZATION_MOBILE_NUMBER",
            "displayCode": "",
            "displayOrder": 7
        },
		{
            "id": 9,
            "value": "primaryeEmailId",
            "resultKey": "ORGANIZATION_EMAILID",
            "displayCode": "",
            "displayOrder": 8
        },
		{
            "id": 10,
            "value": "alternateEmailId",
            "resultKey": "ORGANIZATION_ALTERNATE_EMAILID",
            "displayCode": "",
            "displayOrder": 9
        },
		{
            "id": 11,
            "value": "ACADEMY_LOCATION_NAME",
            "resultKey": "ACADEMY_LOCATION_NAME",
            "displayCode": "",
            "displayOrder": 10
        },
		{
            "id": 12,
            "value": "addressText",
            "resultKey": "ACADEMY_ADDRESS",
            "displayCode": "",
            "displayOrder": 11
        },
		{
            "id": 13,
            "value": "countryName",
            "resultKey": "ACADEMY_COUNTRY_NAME",
            "displayCode": "",
            "displayOrder": 12
        },
		{
            "id": 14,
            "value": "countryRegionName",
            "resultKey": "ACADEMY_REGION_NAME",
            "displayCode": "",
            "displayOrder": 13
        },
		{
            "id": 15,
            "value": "cityName",
            "resultKey": "ACADEMY_CITY_NAME",
            "displayCode": "",
            "displayOrder": 14
        },
		{
            "id": 16,
            "value": "postalCode",
            "resultKey": "ACADEMY_POSTALCODE",
            "displayCode": "",
            "displayOrder": 15
        },
		{
            "id": 17,
            "value": "phoneNo",
            "resultKey": "ACADEMY_PHONE_NUMBER",
            "displayCode": "",
            "displayOrder": 16
        },
		{
            "id": 18,
            "value": "cellNo",
            "resultKey": "ACADEMY_MOBILE_NUMBER",
            "displayCode": "",
            "displayOrder": 17
        },
		{
            "id": 19,
            "value": "primaryeEmailId",
            "resultKey": "ACADEMY_EMAILID",
            "displayCode": "",
            "displayOrder": 18
        },
		{
            "id": 20,
            "value": "code",
            "resultKey": "STUDENT_ID",
            "displayCode": "",
            "displayOrder": 19
        },
		{
            "id": 21,
            "value": "printName",
            "resultKey": "STUDENT_NAME",
            "displayCode": "",
            "displayOrder": 20
        },
		{
            "id": 22,
            "value": "salutationName",
            "resultKey": "SALUTATION",
            "displayCode": "",
            "displayOrder": 21
        },
		{
            "id": 23,
            "value": "code",
            "resultKey": "APPLICANT_CODE",
            "displayCode": "",
            "displayOrder": 22
        },
		{
            "id": 24,
            "value": "printName",
            "resultKey": "APPLICANT_PRINT_NAME",
            "displayCode": "",
            "displayOrder": 23
        },
		{
            "id": 25,
            "value": "programCode",
            "resultKey": "PROGRAMCODE",
            "displayCode": "",
            "displayOrder": 24
        },
		{
            "id": 26,
            "value": "programNameToBePrint",
            "resultKey": "PROGRAM_PRINT_NAME",
            "displayCode": "",
            "displayOrder": 25
        },
		{
            "id": 27,
            "value": "PROGRAM_DEPARTMENT_NAME",
            "resultKey": "PROGRAM_DEPARTMENT_NAME",
            "displayCode": "",
            "displayOrder": 26
        },
        {
            "id": 28,
            "value": "PROGRAM_SUB_DEPARTMENT_NAME",
            "resultKey": "PROGRAM_SUB_DEPARTMENT_NAME",
            "displayCode": "",
            "displayOrder": 27
        },
        {
            "id": 29,
            "value": "startDate",
            "resultKey": "INTAKE_START_DATE",
            "displayCode": "",
            "displayOrder": 28
        },
        {
            "id": 30,
            "value": "tillDate",
            "resultKey": "INTAKE_END_DATE",
            "displayCode": "",
            "displayOrder": 29
        },
        {
            "id": 31,
            "value": "printName",
            "resultKey": "PERIOD_PRINT_NAME",
            "displayCode": "",
            "displayOrder": 30
        },
        {
            "id": 32,
            "value": "TODAYS_DATE",
            "resultKey": "TODAYS_DATE",
            "displayCode": "",
            "displayOrder": 31
        },
        {
            "id": 33,
            "value": "itemValue",
            "resultKey": "STUDENT_GENDER",
            "displayCode": "",
            "displayOrder": 32
        },
        {
            "id": 34,
            "value": "admissionDate",
            "resultKey": "ADMISSION_DATE",
            "displayCode": "",
            "displayOrder": 33
        },
		{
            "id": 35,
            "value": "code",
            "resultKey": "ADMISSION_ID",
            "displayCode": "",
            "displayOrder": 34
        },
		{
            "id": 36,
            "value": "groupName",
            "resultKey": "PROGRAM_GROUP_NAME",
            "displayCode": "",
            "displayOrder": 35
        },
		{
            "id": 37,
            "value": "initials",
            "resultKey": "INITIALS",
            "displayCode": "",
            "displayOrder": 36
        },
		{
            "id": 38,
            "value": "itemValue",
            "resultKey": "MODE_OF_DELIVERY",
            "displayCode": "",
            "displayOrder": 37
        },
		{
            "id": 39,
            "value": "nationalID",
            "resultKey": "IDENTITY_NUMBER",
            "displayCode": "",
            "displayOrder": 38
        },
		{
            "id": 40,
            "value": "mobileNumber",
            "resultKey": "MOBILE_NO",
            "displayCode": "",
            "displayOrder": 39
        },
		{
            "id": 41,
            "value": "emailId",
            "resultKey": "EMAIL_ID",
            "displayCode": "",
            "displayOrder": 40
        },
		{
            "id": 42,
            "value": "alternateEmailId",
            "resultKey": "ALTERNATE_EMAIL_ID",
            "displayCode": "",
            "displayOrder": 41
        },
		{
            "id": 43,
            "value": "printName",
            "resultKey": "INITIATED_BY",
            "displayCode": "",
            "displayOrder": 42
        },
		{
            "id": 44,
            "value": "requestDate",
            "resultKey": "REQUEST_DATE",
            "displayCode": "",
            "displayOrder": 43
        },
		{
            "id": 45,
            "value": "remarks",
            "resultKey": "DEBARMENT_REMARK",
            "displayCode": "",
            "displayOrder": 44
        },
		{
            "id": 46,
            "value": "DEBARMENT_REASON_AND_REMARK",
            "resultKey": "DEBARMENT_REASON_AND_REMARK",
            "displayCode": "",
            "displayOrder": 45
        },
		{
            "id": 47,
            "value": "firstName",
            "resultKey": "FIRST_NAME",
            "displayCode": "",
            "displayOrder": 46
        },
		{
            "id": 48,
            "value": "fromDate",
            "resultKey": "DEBARMENT_FROM_DATE",
            "displayCode": "",
            "displayOrder": 47
        },
		{
            "id": 49,
            "value": "toDate",
            "resultKey": "DEBARMENT_TO_DATE",
            "displayCode": "",
            "displayOrder": 48
        }
		
    ]
 }');
 
 SET @dtprvdrinputparamId=(SELECT MAX(id) FROM dtprvdr_input_param);
 SET @dtproviderId=(SELECT id FROM `dtprovider` where `dataProviderName`='EMAIL_CERTIFICATE_DEBARMENT_DL');
 SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='CONFIG_LEVEL_VALUE');
 INSERT INTO `dtprvdr_input_param` (`id`, `dataProviderId`, `paramName`, `paramDataType`, `paramType`, `msgScopeParamId`, `operatorCode`, `additionalInputParamId`) VALUES(@dtprvdrinputparamId+1,@dtproviderId,'T1.id','NUMBER_EQUAL','SCOPEPARAM',@msgScopeParamId,'NUMBER_EQUAL',NULL);
 
 SET @msgtemplateId=(SELECT MAX(id) FROM msg_template);
 SET @sysMsgEventId=(SELECT id FROM system_msg_event where code='EMAIL_CERTIFICATE_DEBARMENT');
 
 SET @msgtemplateconfigId=(SELECT MAX(id) FROM msg_template_config);
 SET @msgSubCategoryId=(SELECT id FROM `msg_category` WHERE `code`='EMAIL_CERTIFICATE_DEBARMENT');
 SET @recipientTypeId=(SELECT id FROM `msg_recipient_type` WHERE `code`='EMAIL_CERTIFICATE_DEBARMENT_RECIPIENT');
 SET @msgMessageTypeId=(SELECT id FROM `msg_message_type` WHERE `code`='Notifications');
 
 INSERT INTO `msg_template_config` (`id`, `code`, `msgSubCategoryId`, `sysMsgEventId`, `recipientTypeId`, `msgMessageTypeId`, `templateDataProviderId`, `templateConfigType`, `templateConfigName`, `whetherBulkMesaging`, `approvalRequired`, `approverId`, `whetherStaticMsg`, `status`, `availableForAdhocMsg`, `academyLocationId`, `authorName`, `authorId`,`whetherEnabled`,`templatelanguageValue`)
 VALUES(@msgtemplateconfigId+1,'Email Certificate Debarment',@msgSubCategoryId,@sysMsgEventId,@recipientTypeId,@msgMessageTypeId,NULL,NULL,'Email Certificate Debarment',NULL,'',NULL,'','APPROVED','','1','System Admin System Admin','1',b'1','English');
 
 INSERT INTO `msg_template` (`id`, `msgTemplateConfigId`, `msgDeliveryModeId`, `subjectLine`, `msgContent`) 
 VALUES (@msgtemplateId+1,@msgtemplateconfigId+1,'1','','');
 
 IF NOT EXISTS ((SELECT * FROM ui_translation WHERE objectName='MESSAGING_TRANSLATIONS' and keyName='EMAIL_CERTIFICATE_DEBARMENT')) THEN 
 INSERT INTO ui_translation (objectName, keyName, defaultValue, customerDefineValue, afriLanguage, vietLanguage,lastUpdate,lastUpdatedBy) 
 VALUES ('MESSAGING_TRANSLATIONS', 'EMAIL_CERTIFICATE_DEBARMENT', 'Email Certificate Debarment', 'Email Certificate Debarment', 'E-pos Sertifikaat Debarment', 'Cấm chứng chỉ email',now(),1);
 END IF;

 IF NOT EXISTS ((SELECT * FROM ui_translation WHERE objectName='MESSAGING_TRANSLATIONS' and keyName='EMAIL_CERTIFICATE_DEBARMENT_DL')) THEN 
 INSERT INTO ui_translation (objectName, keyName, defaultValue, customerDefineValue, afriLanguage, vietLanguage,lastUpdate,lastUpdatedBy) 
 VALUES ('MESSAGING_TRANSLATIONS', 'EMAIL_CERTIFICATE_DEBARMENT_DL', 'Email Certificate Debarment DL', 'Email Certificate Debarment DL', 'E-pos Sertifikaat Debarment DL', 'Lệnh cấm chứng chỉ email DL',now(),1);
 END IF;

 IF NOT EXISTS ((SELECT * FROM ui_translation WHERE objectName='MESSAGING_TRANSLATIONS' and keyName='EMAIL_CERTIFICATE_DEBARMENT_RECIPIENT')) THEN 
 INSERT INTO ui_translation (objectName, keyName, defaultValue, customerDefineValue, afriLanguage, vietLanguage,lastUpdate,lastUpdatedBy) 
 VALUES ('MESSAGING_TRANSLATIONS', 'EMAIL_CERTIFICATE_DEBARMENT_RECIPIENT', 'Email Certificate Debarment Recipient', 'Email Certificate Debarment Recipient', 'E-pos Sertifikaat Debarment Ontvanger', 'Người nhận cấm chứng chỉ email',now(),1);
 END IF;

 IF NOT EXISTS ((SELECT * FROM ui_translation WHERE objectName='MESSAGING_TRANSLATIONS' and keyName='DEBARMENT_REMARK')) THEN 
 INSERT INTO ui_translation (objectName, keyName, defaultValue, customerDefineValue, afriLanguage, vietLanguage,lastUpdate,lastUpdatedBy) 
 VALUES ('MESSAGING_TRANSLATIONS', 'DEBARMENT_REMARK', 'Debarment Remark', 'Debarment Remark', 'Debarment Opmerking', 'Tuyên bố cấm tham gia',now(),1);
 END IF;

 IF NOT EXISTS ((SELECT * FROM ui_translation WHERE objectName='MESSAGING_TRANSLATIONS' and keyName='DEBARMENT_REASON_AND_REMARK')) THEN 
 INSERT INTO ui_translation (objectName, keyName, defaultValue, customerDefineValue, afriLanguage, vietLanguage,lastUpdate,lastUpdatedBy) 
 VALUES ('MESSAGING_TRANSLATIONS', 'DEBARMENT_REASON_AND_REMARK', 'Debarment Remark And Reason', 'Debarment Remark And Reason', 'Debarment Opmerking En Rede', 'Nhận xét và lý do cấm tham gia',now(),1);
 END IF;

 IF NOT EXISTS ((SELECT * FROM ui_translation WHERE objectName='MESSAGING_TRANSLATIONS' and keyName='DEBARMENT_FROM_DATE')) THEN 
 INSERT INTO ui_translation (objectName, keyName, defaultValue, customerDefineValue, afriLanguage, vietLanguage,lastUpdate,lastUpdatedBy) 
 VALUES ('MESSAGING_TRANSLATIONS', 'DEBARMENT_FROM_DATE', 'Debarment From Date', 'Debarment From Date', 'Uitsluiting vanaf datum', 'Cấm từ ngày',now(),1);
 END IF;

 IF NOT EXISTS ((SELECT * FROM ui_translation WHERE objectName='MESSAGING_TRANSLATIONS' and keyName='DEBARMENT_TO_DATE')) THEN 
 INSERT INTO ui_translation (objectName, keyName, defaultValue, customerDefineValue, afriLanguage, vietLanguage,lastUpdate,lastUpdatedBy) 
 VALUES ('MESSAGING_TRANSLATIONS', 'DEBARMENT_TO_DATE', 'Debarment To Date', 'Debarment To Date', 'Debarment tot op datum', 'Cấm cho đến nay',now(),1);
 END IF;

 IF NOT EXISTS ((SELECT * FROM `picklist_translation` WHERE `key`='EMAIL_CERTIFICATE_DEBARMENT')) THEN
 INSERT INTO `picklist_translation` (`key`, `en`) VALUES ('EMAIL_CERTIFICATE_DEBARMENT', 'Email Certificate Debarment');
 END IF;
  
 IF NOT EXISTS ((SELECT * FROM `picklist_translation` WHERE `key`='EMAIL_CERTIFICATE_DEBARMENT_DL')) THEN
 INSERT INTO `picklist_translation` (`key`, `en`) VALUES ('EMAIL_CERTIFICATE_DEBARMENT_DL', 'Email Certificate Debarment DL');
 END IF;
  
 IF NOT EXISTS ((SELECT * FROM `picklist_translation` WHERE `key`='EMAIL_CERTIFICATE_DEBARMENT_RECIPIENT')) THEN
 INSERT INTO `picklist_translation` (`key`, `en`) VALUES ('EMAIL_CERTIFICATE_DEBARMENT_RECIPIENT', 'Email Certificate Debarment Recipient');
 END IF; 
 
END IF;

END $$
CALL V20240501115336__Insert_Email_Certificate_Debarment_Event() $$
DROP PROCEDURE IF EXISTS V20240501115336__Insert_Email_Certificate_Debarment_Event $$
DELIMITER ;