DELIMITER $$
DROP PROCEDURE IF EXISTS V20240605171617__Update_BlackboardUserCreationNotification $$
CREATE PROCEDURE V20240605171617__Update_BlackboardUserCreationNotification()
BEGIN
SET SQL_SAFE_UPDATES=0;
IF EXISTS ((SELECT * FROM dtprovider WHERE `dataProviderName`='BLACKBOARD_USER_CREATION_NOTIFICATION_RECIPIENTS')) THEN 
update sql_dtprovider set sqlQuery="select
T1.id AS ID,
 T1.code as STUDENT_CODE,
T1.printName as PRINT_NAME,
T1.firstName as FIRST_NAME,
T1.lastName as LAST_NAME,
T5.displayName as ACADEMY_LOCATION_NAME,
T4.code as ADMISSION_ID,
T3.emailId as EMAIL_ID,
T8.programNameToBePrint as PROGRAM_PRINT_NAME,
T7.batchName as BATCH,
T9.programPeriodName as PERIOD,
concat(T14.countryName,', ',T13.countryRegionName,', ',T12.cityName,', ',T11.pincode,', ',T11.phoneNo,', ',T11.cellNo,', ',T11.primaryeEmailId) as STUDENT_ADDRESS,
T3.alternateEmailId as ALTERNATE_EMAIL_ID,
concat(T3.mobileCountryCode,'',T3.mobileNumber) as MOBILE_NO,
T16.orgName as ORGANIZATION_NAME,
concat(T20.countryName,', ',T21.countryRegionName,', ',T19.cityName,', ',T18.pincode,', ',T18.phoneNo,', ',T18.cellNo,', ',T18.primaryeEmailId) as ORGANIZATION_ADDRESS,
T5.locationName as ACADEMY_LOCATION,
(Case 
    when T5.logoUrl is null and org.orgUrl IS NOT NULL then CONCAT(org.orgUrl, '/', 'emailer/images/logo_default_image.png') 
    when T5.logoUrl is null and org.orgUrl is null then 'https://www.serosoft.com/mailer/academiaerp_logo_red.png'
    else CONCAT(org.orgUrl, '/', T5.logoUrl)end) as LOGO_URL,
    (Case when T5.headerUrl is not null and org.orgUrl IS NOT NULL then CONCAT(org.orgUrl, '/', T5.headerUrl) 
    else NULL end) as HEADER_URL,
        (Case when T5.footerUrl is not null and org.orgUrl IS NOT NULL then CONCAT(org.orgUrl, '/', T5.footerUrl) 
    else NULL end) as FOOTER_URL 
from users as T1
inner join students as T2 on T2.userId=T1.id
left join persons as T3 on T3.id=T2.personId
left join admission as T4 on T4.studentId=T2.userId
left join academy_location as T5 on T5.id=T4.academyLocationId
left join program_batch_students T6 ON T6.admissionId = T5.id
LEFT JOIN batches T7 ON T7.id = T6.programBatchId
LEFT JOIN programs T8 ON T8.id = T7.programId
LEFT JOIN prog_batch_period_config T9 ON T9.id = T6.progBatchPeriodConfigId
LEFT JOIN academy_location_addresses T10 ON T10.academyLocationId = T4.academyLocationId
LEFT JOIN address T11 ON T11.id = T10.addressId AND T11.addressTypeId = 5
left join city T12 on T12.id=T11.cityId
left join country_region T13 on T13.id=T12.countryRegionId
left join country T14 on T14.id=T12.countryId
left join locations T15 on T14.id=T5.locationId
left join organizations T16 on T16.id=T15.organizationId
left join location_addresses T17 on T17.locationId=T15.id
left join address T18 on T18.id=T17.addressId and T18.addressTypeId = 3
left join city T19 on T19.id=T18.cityId
left join country T20 on T20.id=T18.countryId
left join country_region T21 on T21.id=T18.countryRegionId
left join organizations org on org.id = 1
where T1.id IN (namedParams) limit 1", jsonString='{
    "id": 1,
    "searchResultViewColumns": [
        {
            "id": 1,
            "value": "code",
            "resultKey": "STUDENT_CODE",
            "displayCode": "",
            "displayOrder": 0
        },{
            "id": 2,
            "value": "printName",
            "resultKey": "PRINT_NAME",
            "displayCode": "",
            "displayOrder": 1
        },{
            "id": 3,
            "value": "firstName",
            "resultKey": "FIRST_NAME",
            "displayCode": "",
            "displayOrder": 2
        },
        {
            "id": 4,
            "value": "lastName",
            "resultKey": "LAST_NAME",
            "displayCode": "",
            "displayOrder": 3
        },
        {
            "id": 5,
            "value": "displayName",
            "resultKey": "ACADEMY_LOCATION_NAME",
            "displayCode": "",
            "displayOrder": 4
        },
        {
            "id": 6,
            "value": "code",
            "resultKey": "ADMISSION_ID",
            "displayCode": "",
            "displayOrder": 5
        },
        {
            "id": 7,
            "value": "emailId",
            "resultKey": "EMAIL_ID",
            "displayCode": "",
            "displayOrder": 6
        },       
        {
            "id": 8,
            "value": "programNameToBePrint",
            "resultKey": "PROGRAM_PRINT_NAME",
            "displayCode": "",
            "displayOrder": 7
        },
        {
            "id": 9,
            "value": "batchName",
            "resultKey": "BATCH",
            "displayCode": "",
            "displayOrder": 8
        },
        {
            "id": 10,
            "value": "programPeriodName",
            "resultKey": "PERIODE",
            "displayCode": "",
            "displayOrder": 9
        },
        {
            "id": 11,
            "value": "student address",
            "resultKey": "STUDENT_ADDRESS",
            "displayCode": "",
            "displayOrder": 10
        },
        {
            "id": 12,
            "value": "alternateEmailId",
            "resultKey": "ALTERNATE_EMAIL_ID",
            "displayCode": "",
            "displayOrder": 11
        },
        {
            "id": 13,
            "value": "mobile number",
            "resultKey": "MOBILE_NO",
            "displayCode": "",
            "displayOrder": 12
        },       
        {
            "id": 14,
            "value": "orgName",
            "resultKey": "ORGANIZATION_NAME",
            "displayCode": "",
            "displayOrder": 13
        },
        {
            "id": 15,
            "value": "organization address",
            "resultKey": "ORGANIZATION_ADDRESS",
            "displayCode": "",
            "displayOrder": 14
        },
{
            "id": 16,
            "value": "locationName",
            "resultKey": "ACADEMY_LOCATION",
            "displayCode": "",
            "displayOrder": 15
        },
        {
            "id": 17,
            "value": "logoUrl",
            "resultKey": "LOGO_URL",
            "displayCode": "",
            "displayOrder": 16
        },
        {
            "id": 18,
            "value": "headerUrl",
            "resultKey": "HEADER_URL",
            "displayCode": "",
            "displayOrder": 17
        },
        {
            "id": 19,
            "value": "footerUrl",
            "resultKey": "FOOTER_URL",
            "displayCode": "",
            "displayOrder": 18
        }    ]
}' where dataProviderId in (select id from dtprovider where dataProviderName like "%BLACKBOARD_USER_CREATION_NOTIFICATION_RECIPIENTS%");
END IF; 
SET SQL_SAFE_UPDATES=1;
END $$
CALL V20240605171617__Update_BlackboardUserCreationNotification () $$
DROP PROCEDURE IF EXISTS V20240605171617__Update_BlackboardUserCreationNotification $$
DELIMITER ;