DELIMITER $$
DROP PROCEDURE IF EXISTS V20240618175412__Update_ScholarshipCancelEvent $$
CREATE PROCEDURE V20240618175412__Update_ScholarshipCancelEvent()
BEGIN
SET SQL_SAFE_UPDATES=0;

IF EXISTS ((select MAX(id) from dtprovider where dataProviderName="SCHOLARSHIP_AWARD_REJECTED_STUDENT_RECIPIENT")) THEN 
SET @dtProviderId=(select MAX(id) from dtprovider where dataProviderName="SCHOLARSHIP_AWARD_REJECTED_STUDENT_RECIPIENT");

UPDATE sql_dtprovider SET sqlQuery="SELECT DISTINCT
    T1.id AS ID,
    T2.printName AS STUDENT_PRINT_NAME,
    T2.firstName AS FIRST_NAME,
    T2.middleName AS MIDDLE_NAME,
    T2.lastName AS LAST_NAME,
    T2.emailId AS EMAIL_ID,
    T2.code AS STUDENT_ID,
    CURDATE() AS CURRENT_DATE_TODAY,
    T3.externalSysRefOne AS STUDENT_EXTERNAL_REFERENCE_NUMBER_1,
    T6.programName AS PROGRAM,
    T5.batchName AS BATCH,
    (CASE
    WHEN T19.id IS NULL THEN T40.programPeriodName
    ELSE T19.programPeriodName
    END) AS PERIOD,
    T8.scholarshipCode AS SCHOLARSHIP_ID,
    T8.scholarshipName AS SCHOLARSHIP_NAME,
    T8.scholarshipCategory AS SCHOLARSHIP_CATEGORY,
    (CASE
    WHEN T1.scholarshipRaiseRequestId IS NULL THEN T30.amount
    ELSE T10.totalScholarshipAmount
    END) AS SCHOLARSHIP_AMOUNT,
    T24.printName AS SCHOLARSHIP_OWNER_NAME,
    T24.emailId AS SCHOLARSHIP_OWNER_EMAIL,
    T12.displayName AS AL,
    T13.addressText AS CURRENT_ADDRESS,
    T14.cityName AS CITY,
    T15.countryName AS COUNTRY,
    T13.pincode AS PIN_CODE,
    T50.cancellationNarration AS REJECTION_REASON,
    T1.remark AS REJECTION_REMARK

FROM
    scholarship_awardee_list_setup T1
        LEFT OUTER JOIN
    students T20 ON T1.studentId = T20.userId    
      LEFT OUTER JOIN
    users T2 ON T20.userId = T2.id    
        LEFT OUTER JOIN
    admission T41 on T41.studentId = T2.id  
       LEFT OUTER JOIN  
    persons T3 ON T20.personId = T3.id
       LEFT OUTER JOIN
    batches T5 ON T5.id = T1.batchId
       LEFT OUTER JOIN
    programs T6 ON T6.id = T1.programId
       LEFT OUTER JOIN
    scholarship T8 ON T8.id = T1.scholarshipId
       LEFT OUTER JOIN
    scholarship_raise_request T10 ON T10.id=T1.scholarshipRaiseRequestId
       LEFT OUTER JOIN
    scholarship_nominate_or_award T30 ON T30.id = T1.nominationId
       LEFT OUTER JOIN
    prog_batch_seat_config T4 ON T10.programBatchSeatConfigId = T4.id
        LEFT OUTER JOIN
    prog_batch_period_config T19 on T19.programBatchId = T4.programBatchId and T19.isCurrentPeriodOfProgram = 1
       LEFT OUTER JOIN
    prog_batch_period_config T40 on T40.programBatchId = T5.id 
      LEFT OUTER JOIN     
    accounting_year T9 ON T9.id=T10.accountingYearId
       LEFT OUTER JOIN
    academy_location T12 ON T12.id=T41.academyLocationId
       LEFT OUTER JOIN
    person_addresses T22 ON T22.personId = T3.id
       LEFT OUTER JOIN
    address T13 ON T22.addressId = T13.id
       LEFT OUTER JOIN
    city T14 on  T14.id=T13.cityId
       LEFT OUTER JOIN
    country T15 ON T15.id=T13.countryId
       LEFT OUTER JOIN
    address_type T16 ON T16.id=T13.addressTypeId AND T16.code='CRNT' AND T16.addressCategory='PERSON'
       LEFT OUTER JOIN
    scholarship_owners T23 ON  T23.scholarshipId=T8.id
       LEFT OUTER JOIN
    users T24 ON T23.ownerId=T24.id
       LEFT OUTER JOIN
    bill_header  T50 on T1.billHeaderId = T50.id 
WHERE T1.status = 'AWARD_ACTIVATION_REJECTED' and
T1.id IN (namedParams) "
   WHERE dataProviderId=@dtProviderId;  

END IF; 

SET SQL_SAFE_UPDATES=1;
END $$
CALL V20240618175412__Update_ScholarshipCancelEvent () $$
DROP PROCEDURE IF EXISTS V20240618175412__Update_ScholarshipCancelEvent $$
DELIMITER ;