DELIMITER $$
DROP PROCEDURE IF EXISTS V20240619181715__Create_SendMonthlyReportPath $$
CREATE PROCEDURE V20240619181715__Create_SendMonthlyReportPath()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Columns WHERE table_schema=DATABASE() AND table_name='send_monthly_report_path')) THEN 
CREATE TABLE `send_monthly_report_path` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `reportDateFrom` DATE NULL,
  `reportDateTo` DATE NULL,
  `transReportUrl` varchar(200) DEFAULT NULL,
  `merchantReportUrl` varchar(200) DEFAULT NULL,
  `lastUpdatedBy` BIGINT DEFAULT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP on update current_timestamp,
  PRIMARY KEY (`id`),
  CONSTRAINT `send_monthly_report_path_fk_user`
    FOREIGN KEY (`lastUpdatedBy`)
    REFERENCES `users` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION);
END IF; 

END $$
CALL V20240619181715__Create_SendMonthlyReportPath () $$ 
DROP PROCEDURE IF EXISTS V20240619181715__Create_SendMonthlyReportPath $$ 
DELIMITER ;