DELIMITER $$
DROP PROCEDURE IF EXISTS V20240712141205__Insert_Agenda_Number_CSM $$
CREATE PROCEDURE V20240712141205__Insert_Agenda_Number_CSM()
BEGIN

SET @currentTimeStamp = (SELECT CURRENT_TIMESTAMP);
SET @standardMasterMaxId=(SELECT MAX(id) FROM standard_master);

IF NOT EXISTS ((SELECT * FROM standard_master WHERE masterName = 'AGENDA_NUMBER_CSM')) THEN 
INSERT INTO `standard_master`(`id`,`childMaster`,`tableName`,`masterName`,`moduleName`,`filterCode`,`whetherChild`,`whetherParent`, `droolsAgenda`,`lastUpdatedBy`,`lastUpdate`) 
VALUES (@standardMasterMaxId+1, NULL,'agenda_number_csm','AGENDA_NUMBER_CSM','Fees & Payments','COMMON_MASTER',0,0,NULL,1,@currentTimeStamp);
END IF; 


IF  EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='standard_master_items')) THEN 
SET @standardMasterId=(select id from standard_master where tableName = 'agenda_number_csm');
INSERT INTO `standard_master_items` (`dbFieldName`,`fieldLabel`,`standardMasterId`,`fieldType`,`emunType`,`diaplayOrder`,`whetherForeignKey`,`fkTable`,`fkFieldName`,`fkDisplayField`,`whetherShortCode`,`whetherReadOnly`,`wheherNullable`,`validationType`,`maxLength`,`minLength`,`lastUpdatedBy`,`lastUpdate`)
VALUES ('itemCode','ITEM_CODE',@standardMasterId,'Varchar',NULL,1,0,NULL,NULL,NULL,0,0,0,NULL,NULL,NULL,1,now());

INSERT INTO `standard_master_items` (`dbFieldName`,`fieldLabel`,`standardMasterId`,`fieldType`,`emunType`,`diaplayOrder`,`whetherForeignKey`,`fkTable`,`fkFieldName`,`fkDisplayField`,`whetherShortCode`,`whetherReadOnly`,`wheherNullable`,`validationType`,`maxLength`,`minLength`,`lastUpdatedBy`,`lastUpdate`)
VALUES ('itemValue','ITEM_VALUE',@standardMasterId,'Varchar',NULL,2,0,NULL,NULL,NULL,0,0,0,NULL,NULL,NULL,1,now());

INSERT INTO `standard_master_items` (`dbFieldName`,`fieldLabel`,`standardMasterId`,`fieldType`,`emunType`,`diaplayOrder`,`whetherForeignKey`,`fkTable`,`fkFieldName`,`fkDisplayField`,`whetherShortCode`,`whetherReadOnly`,`wheherNullable`,`validationType`,`maxLength`,`minLength`,`lastUpdatedBy`,`lastUpdate`)
VALUES ('sequence','SEQUENCE',@standardMasterId,'Number',NULL,3,0,NULL,NULL,NULL,0,0,0,NULL,NULL,NULL,1,now());

END IF; 

-- translations

IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE objectName = 'masterNames' and keyName = 'AGENDA_NUMBER_CSM')) THEN 
INSERT INTO `ui_translation` (`objectName`, `keyName`, `defaultValue`, `customerDefineValue`,`afriLanguage`,`vietLanguage`,`lastUpdate`,`lastUpdatedBy`)
VALUES ('masterNames', 'AGENDA_NUMBER_CSM', 'Agenda Number', 'Agenda Number','Agenda nommer','Số chương trình nghị sự',now(),1);
END IF; 

END $$
CALL V20240712141205__Insert_Agenda_Number_CSM() $$
DROP PROCEDURE IF EXISTS V20240712141205__Insert_Agenda_Number_CSM $$
DELIMITER ;