DELIMITER $$
DROP PROCEDURE IF EXISTS V20240723115606__Update_quotation_details_ui_translation $$
CREATE PROCEDURE V20240723115606__Update_quotation_details_ui_translation()
BEGIN


SET SQL_SAFE_UPDATES=0;


IF EXISTS (SELECT * FROM ui_translation WHERE objectName = "QUOTATION" and keyName = "PROVISIONAL_QUOTATION_INT_TITLE_2") THEN
UPDATE ui_translation 
SET 
    defaultValue = 'Welcome to the application enabling you to obtain a Provisional Quotation of Fees for degree-seeking international students via the web. The programme was tested; however, in view of the complex nature and variety of possible combinations, problems may occur. We thank you in anticipation for your understanding and patience. Students with valid spousal permits, please contact  [PROVISIONAL_QUOTATION_INT_TITLE_4_EMAIL] to request a budget and send the relevant proof. Students with a valid work permit must choose the option (Foreigner without a study visa (Non-residential/ITO) to generate a budget.',
    customerDefineValue = 'Welcome to the application enabling you to obtain a Provisional Quotation of Fees for degree-seeking international students via the web. The programme was tested; however, in view of the complex nature and variety of possible combinations, problems may occur. We thank you in anticipation for your understanding and patience. Students with valid spousal permits, please contact  [PROVISIONAL_QUOTATION_INT_TITLE_4_EMAIL] to request a budget and send the relevant proof. Students with a valid work permit must choose the option(Foreigner without a study visa (Non-residential/ITO) to generate a budget.',
    afriLanguage = 'Welkom by die aansoek wat jou in staat stel om n voorlopige kwotasie van fooie vir graad-soekende internasionale studente via die web te verkry. Die program is getoets; in die lig van die komplekse aard en verskeidenheid van moontlike kombinasies kan probleme egter voorkom. Ons bedank u in afwagting vir u begrip en geduld. Studente met geldige huwelikspermitte, kontak asb [PROVISIONAL_QUOTATION_INT_TITLE_2] om n begroting aan te vra en die relevante bewys te stuur. Studente met n geldige werkpermit moet die opsie (Buitelander sonder n studievisum (Nie-residensieel/ITO) kies om n begroting te genereer.'
WHERE
    keyName = 'PROVISIONAL_QUOTATION_INT_TITLE_2' and objectName = "QUOTATION";
END IF;    
    
IF EXISTS (SELECT * FROM ui_translation WHERE objectName = "QUOTATION" and keyName = "PROVISIONAL_QUOTATION_INT_TITLE_4") THEN  
  UPDATE ui_translation 
SET 
    defaultValue = 'Please report any problems to [PROVISIONAL_QUOTATION_INT_TITLE_2_EMAIL], offering as much detail as possible.',
    customerDefineValue = 'Please report any problems to [PROVISIONAL_QUOTATION_INT_TITLE_2_EMAIL], offering as much detail as possible.',
    afriLanguage = 'Rapporteer asseblief enige probleme by [PROVISIONAL_QUOTATION_INT_TITLE_2_EMAIL], bied soveel detail as moontlik.'

WHERE
    keyName = 'PROVISIONAL_QUOTATION_INT_TITLE_4' and objectName = "QUOTATION";
END IF;


IF EXISTS (SELECT * FROM ui_translation WHERE objectName = "QUOTATION" and keyName = "PROVISIONAL_QUOTATION_INT_PAGE1_P4") THEN
UPDATE ui_translation 
SET 
    defaultValue = 'If in doubt about the curriculum of the intended programme to be followed, please refer to the particular Calendar of the Faculty involved at  [PROVISIONAL_QUOTATION_INT_PAGE1_P4_HYPERLINK]',
    customerDefineValue = 'If in doubt about the curriculum of the intended programme to be followed, please refer to the particular Calendar of the Faculty involved at  [PROVISIONAL_QUOTATION_INT_PAGE1_P4_HYPERLINK]',
    afriLanguage ='Indien jy twyfel oor die kurrikulum van die beoogde program wat gevolg gaan word, verwys asseblief na die betrokke Jaarboek van die betrokke Fakulteit by [PROVISIONAL_QUOTATION_INT_PAGE1_P4_HYPERLINK]'
WHERE
    keyName = 'PROVISIONAL_QUOTATION_INT_PAGE1_P4' and  objectName = "QUOTATION";
END IF;

IF EXISTS (SELECT * FROM ui_translation WHERE objectName = "QUOTATION" and keyName = "HYPER_LINK_3") THEN
UPDATE ui_translation 
SET 
    keyName = 'PROVISIONAL_QUOTATION_INT_PAGE2_P2_HYPER_LINK'
   WHERE
    keyName = 'HYPER_LINK_3' and objectName = "QUOTATION";
END IF;

IF EXISTS (SELECT * FROM ui_translation WHERE objectName = "QUOTATION" and keyName = "HYPER_LINK_4") THEN
UPDATE ui_translation 
SET 
    keyName = 'PROVISIONAL_QUOTATION_INT_PAGE3_P1_HYPER_LINK'
   WHERE
    keyName = 'HYPER_LINK_4' and objectName = "QUOTATION";
END IF;


IF EXISTS (SELECT * FROM ui_translation WHERE objectName = "QUOTATION" and keyName = "PROVISIONAL_QUOTATION_ALERT_P1") THEN
update ui_translation
set defaultValue = "Modules with a total credit value of [PROVISIONAL_QUOTATION_ALERT_VALUE_1] have been selected. The required credit is [PROVISIONAL_QUOTATION_ALERT_VALUE_2] .",
customerDefineValue = "Modules with a total credit value of [PROVISIONAL_QUOTATION_ALERT_VALUE_1] have been selected. The required credit is [PROVISIONAL_QUOTATION_ALERT_VALUE_2] .",
afriLanguage="Modules met n totale kredietwaarde van [PROVISIONAL_QUOTATION_ALERT_VALUE_1] is gekies. Die vereiste krediet is [PROVISIONAL_QUOTATION_ALERT_VALUE_2]."
where keyName = "PROVISIONAL_QUOTATION_ALERT_P1" and objectName = "QUOTATION";
END IF;


IF EXISTS (SELECT * FROM ui_translation WHERE objectName = "QUOTATION" and keyName = "PROVISIONAL_QUOTATION_ALERT_P2") THEN
update ui_translation
set KeyName = "PROVISIONAL_QUOTATION_ALERT_VALUE_2" ,
defaultValue = "0",
customerDefineValue = "0",
afriLanguage = "0"
where keyName = "PROVISIONAL_QUOTATION_ALERT_P2" and objectName = "QUOTATION";
END IF;


IF EXISTS (SELECT * FROM ui_translation WHERE objectName = "QUOTATION" and keyName = "PROVISIONAL_QUOTATION_ALERT_P3") THEN
update ui_translation
set KeyName = "PROVISIONAL_QUOTATION_ALERT_VALUE_1" ,
defaultValue = "0",
customerDefineValue = "0",
afriLanguage = "0"
where keyName = "PROVISIONAL_QUOTATION_ALERT_P3" and objectName = "QUOTATION";
END IF;



IF EXISTS (SELECT * FROM ui_translation WHERE objectName = "QUOTATION" and keyName = "PROVISIONAL_QUOTATION_INT_PAGE2_P2") THEN
UPDATE ui_translation
set defaultValue = "Through Interactive Telematic Education the Division for Telematic Services enhances the virtual mobility of geographically dispersed students to broaden their participation in the academic offering of Stellenbosch University ‐ especially those who want to combine a professional career with further postgraduate studies to maximise their potential. The enhancement of the students’ virtual mobility blurs the customary divide between face to-face and off-campus educational opportunities, while the barriers often set by location and time are reduced. This flexible learning strategy relies on a unique technology platform that integrates satellite, mobile, web-based, smart card and video conference technologies. [PROVISIONAL_QUOTATION_INT_PAGE2_P2_HYPER_LINK]",
customerDefineValue = "Through Interactive Telematic Education the Division for Telematic Services enhances the virtual mobility of geographically dispersed students to broaden their participation in the academic offering of Stellenbosch University ‐ especially those who want to combine a professional career with further postgraduate studies to maximise their potential. The enhancement of the students’ virtual mobility blurs the customary divide between face to-face and off-campus educational opportunities, while the barriers often set by location and time are reduced. This flexible learning strategy relies on a unique technology platform that integrates satellite, mobile, web-based, smart card and video conference technologies. [PROVISIONAL_QUOTATION_INT_PAGE2_P2_HYPER_LINK]",
afriLanguage = "Deur Interaktiewe Telematiese Onderwys bevorder die Afdeling Telematiese Dienste die virtuele mobiliteit van geografies verspreide studente om hul deelname aan die akademiese aanbod van die Universiteit Stellenbosch te verbreed – veral diegene wat n professionele loopbaan met verdere nagraadse studies wil kombineer om hul potensiaal te maksimeer. Die verbetering van die studente se virtuele mobiliteit vervaag die gebruiklike skeiding tussen aangesig-tot-aangesig en buite-kampus opvoedkundige geleenthede, terwyl die hindernisse wat dikwels deur plek en tyd gestel word, verminder word. Hierdie buigsame leerstrategie maak staat op n unieke tegnologieplatform wat satelliet-, selfoon-, webgebaseerde, slimkaart- en videokonferensietegnologieë integreer. [PROVISIONAL_QUOTATION_INT_PAGE2_P2_HYPER_LINK]"
where keyName = "PROVISIONAL_QUOTATION_INT_PAGE2_P2" and objectName = "QUOTATION";
END IF;



IF EXISTS (select * from ui_translation where  objectName = "QUOTATION" and keyName = "PROVISIONAL_QUOTATION_INT_TITLE_3") THEN
delete from ui_translation where keyName = "PROVISIONAL_QUOTATION_INT_TITLE_3";
END IF;

IF EXISTS (select * from ui_translation where  objectName = "QUOTATION" and keyName = "PROVISIONAL_QUOTATION_INT_TITLE_5") THEN
delete from ui_translation where keyName = "PROVISIONAL_QUOTATION_INT_TITLE_5";
END IF;

IF EXISTS (select * from ui_translation where  objectName = "QUOTATION" and keyName = "HYPER_LINK_1") THEN
delete from ui_translation where keyName = "HYPER_LINK_1";
END IF;

IF EXISTS (select * from ui_translation where  objectName = "QUOTATION" and keyName = "HYPER_LINK_2") THEN
delete from ui_translation where keyName = "HYPER_LINK_2";
END IF;

IF NOT EXISTS(select * from ui_translation where  objectName = "QUOTATION" and keyName = "EDP") THEN
INSERT INTO ui_translation (`objectName`, `keyName`, `defaultValue`, `customerDefineValue`, `afriLanguage`, `lastUpdate`, `lastUpdatedBy`)
VALUES ('QUOTATION', 'EDP', '[EDP] Extended Degree Programmes', '[EDP] Extended Degree Programmes', '[VGP] Verlengde graadprogramme', now(), 1);
END IF;

IF NOT EXISTS(select * from ui_translation where  objectName = "QUOTATION" and keyName = "ITE") THEN
INSERT INTO ui_translation (`objectName`, `keyName`, `defaultValue`, `customerDefineValue`, `afriLanguage`, `lastUpdate`, `lastUpdatedBy`)
VALUES ('QUOTATION', 'ITE', '[ITE] Interactive Telematic Education', '[ITE] Interactive Telematic Education', '[ITE] Interaktiewe Telematiese Onderwys', now(), 1);
END IF;

IF NOT EXISTS(select * from ui_translation where  objectName = "QUOTATION" and keyName = "BACK") THEN
INSERT INTO ui_translation (`objectName`, `keyName`, `defaultValue`, `customerDefineValue`, `afriLanguage`, `lastUpdate`, `lastUpdatedBy`)
VALUES ('QUOTATION', 'BACK', 'Back', 'Back', 'Terug', now(), 1);
END IF;

IF NOT EXISTS(select * from ui_translation where  objectName = "QUOTATION" and keyName = "PROVISIONAL_QUOTATION_GIVEN_WITHOUT_PREJUDICE_2") THEN
INSERT INTO ui_translation (`objectName`, `keyName`, `defaultValue`, `customerDefineValue`, `afriLanguage`, `lastUpdate`, `lastUpdatedBy`)
VALUES ('QUOTATION', 'PROVISIONAL_QUOTATION_GIVEN_WITHOUT_PREJUDICE_2', 'Provisional Quotation Given Without Prejudice', 'Provisional Quotation Given Without Prejudice', 'Voorlopige kwotasie gegee sonder vooroordeel', now(), 1);
END IF;

IF NOT EXISTS(select * from ui_translation where  objectName = "QUOTATION" and keyName = "PROVISIONAL_QUOTATION_GIVEN_WITHOUT_PREJUDICE_3") THEN
INSERT INTO ui_translation (`objectName`, `keyName`, `defaultValue`, `customerDefineValue`, `afriLanguage`, `lastUpdate`, `lastUpdatedBy`)
VALUES ('QUOTATION', 'PROVISIONAL_QUOTATION_GIVEN_WITHOUT_PREJUDICE_3', 'Provisional Quotation Given Without Prejudice', 'Provisional Quotation Given Without Prejudice', 'Voorlopige kwotasie gegee sonder vooroordeel', now(), 1);
END IF;

IF NOT EXISTS(select * from ui_translation where  objectName = "QUOTATION" and keyName = "PROVISIONAL_QUOTATION_INT_TITLE_2_EMAIL") THEN
INSERT INTO ui_translation (`objectName`, `keyName`, `defaultValue`, `customerDefineValue`, `afriLanguage`, `lastUpdate`, `lastUpdatedBy`)
VALUES ('QUOTATION', 'PROVISIONAL_QUOTATION_INT_TITLE_2_EMAIL', 'suifinance@sun.ac.za', 'suifinance@sun.ac.za', 'suifinance@sun.ac.za', now(), 1);
END IF;

IF NOT EXISTS(select * from ui_translation where  objectName = "QUOTATION" and keyName = "PROVISIONAL_QUOTATION_INT_TITLE_4_EMAIL") THEN
INSERT INTO ui_translation (`objectName`, `keyName`, `defaultValue`, `customerDefineValue`, `afriLanguage`, `lastUpdate`, `lastUpdatedBy`)
VALUES ('QUOTATION', 'PROVISIONAL_QUOTATION_INT_TITLE_4_EMAIL', 'suifinance@sun.ac.za', 'suifinance@sun.ac.za', 'suifinance@sun.ac.za', now(), 1);
END IF;


IF NOT EXISTS(select * from ui_translation where  objectName = "QUOTATION" and keyName = "PROVISIONAL_QUOTATION_INT_PAGE1_P4_HYPERLINK") THEN
INSERT INTO ui_translation (`objectName`, `keyName`, `defaultValue`, `customerDefineValue`, `afriLanguage`, `lastUpdate`, `lastUpdatedBy`)
VALUES ('QUOTATION', 'PROVISIONAL_QUOTATION_INT_PAGE1_P4_HYPERLINK', 'http://www.sun.ac.za/english/faculty/Pages/default.aspx', 'http://www.sun.ac.za/english/faculty/Pages/default.aspx', 'http://www.sun.ac.za/english/faculty/Pages/default.aspx', now(), 1);
END IF;

IF NOT EXISTS(select * from ui_translation where  objectName = "QUOTATION" and keyName = "SELECT_ACADEMY_LOCATION") THEN
INSERT INTO ui_translation (`objectName`, `keyName`, `defaultValue`, `customerDefineValue`, `afriLanguage`, `lastUpdate`, `lastUpdatedBy`)
VALUES ('QUOTATION', 'SELECT_ACADEMY_LOCATION', 'Select an Academy Location', 'Select an Academy Location', 'Kies n Akademie-ligging', now(), 1);
END IF;

IF NOT EXISTS(select * from ui_translation where  objectName = "QUOTATION" and keyName = "WARNING") THEN
INSERT INTO ui_translation (`objectName`, `keyName`, `defaultValue`, `customerDefineValue`, `afriLanguage`, `lastUpdate`, `lastUpdatedBy`)
VALUES ('QUOTATION', 'WARNING', 'Warning', 'Warning', 'Waarskuwing', now(), 1);
END IF;

IF NOT EXISTS(select * from ui_translation where  objectName = "QUOTATION" and keyName = "PLEASE_SELECT_ONE_MODULE") THEN
INSERT INTO ui_translation (`objectName`, `keyName`, `defaultValue`, `customerDefineValue`, `afriLanguage`, `lastUpdate`, `lastUpdatedBy`)
VALUES ('QUOTATION', 'PLEASE_SELECT_ONE_MODULE', 'Please select atleast one module.', 'Please select atleast one module.', 'Kies asseblief ten minste een module.', now(), 1);
END IF;

IF NOT EXISTS(select * from ui_translation where  objectName = "QUOTATION" and keyName = "ACADEMY_LOCATION_MANDATORY") THEN
INSERT INTO ui_translation (`objectName`, `keyName`, `defaultValue`, `customerDefineValue`, `afriLanguage`, `lastUpdate`, `lastUpdatedBy`)
VALUES ('QUOTATION', 'ACADEMY_LOCATION_MANDATORY', 'Academy Location is required', 'Academy Location is required', 'Akademie-ligging word vereis', now(), 1);
END IF;

IF NOT EXISTS(select * from ui_translation where  objectName = "QUOTATION" and keyName = "ACADEMIC_TREM_MANDATORY") THEN
INSERT INTO ui_translation (`objectName`, `keyName`, `defaultValue`, `customerDefineValue`, `afriLanguage`, `lastUpdate`, `lastUpdatedBy`)
VALUES ('QUOTATION', 'ACADEMIC_TREM_MANDATORY', 'Academic Term is required', 'Academic Term is required', 'Akademiese kwartaal word vereis', now(), 1);
END IF;

IF NOT EXISTS(select * from ui_translation where  objectName = "QUOTATION" and keyName = "PROGRAM_GROUP_MANDATORY") THEN
INSERT INTO ui_translation (`objectName`, `keyName`, `defaultValue`, `customerDefineValue`, `afriLanguage`, `lastUpdate`, `lastUpdatedBy`)
VALUES ('QUOTATION', 'PROGRAM_GROUP_MANDATORY', 'Program Group is required', 'Program Group is required', 'Programgroep word vereis', now(), 1);
END IF;

IF NOT EXISTS(select * from ui_translation where  objectName = "QUOTATION" and keyName = "PROGRAM_CODE_MANDATORY") THEN
INSERT INTO ui_translation (`objectName`, `keyName`, `defaultValue`, `customerDefineValue`, `afriLanguage`, `lastUpdate`, `lastUpdatedBy`)
VALUES ('QUOTATION', 'PROGRAM_CODE_MANDATORY', 'Program Name/Code is required', 'Program Name/Code is required', 'Programnaam/kode word vereis', now(), 1);
END IF;

IF NOT EXISTS(select * from ui_translation where  objectName = "QUOTATION" and keyName = "PERIOD_YEAR_MANDATORY") THEN
INSERT INTO ui_translation (`objectName`, `keyName`, `defaultValue`, `customerDefineValue`, `afriLanguage`, `lastUpdate`, `lastUpdatedBy`)
VALUES ('QUOTATION', 'PERIOD_YEAR_MANDATORY', 'Period Year is required', 'Period Year is required', 'Periode Jaar word vereis', now(), 1);
END IF;

IF NOT EXISTS(select * from ui_translation where  objectName = "QUOTATION" and keyName = "ACCOMMODATION") THEN
INSERT INTO ui_translation (`objectName`, `keyName`, `defaultValue`, `customerDefineValue`, `afriLanguage`, `lastUpdate`, `lastUpdatedBy`)
VALUES ('QUOTATION', 'ACCOMMODATION', 'Accommodation', 'Accommodation', 'Akkommodasie', now(), 1);
END IF;

IF NOT EXISTS(select * from ui_translation where  objectName = "QUOTATION" and keyName = "FULL_NAME") THEN
INSERT INTO ui_translation (`objectName`, `keyName`, `defaultValue`, `customerDefineValue`, `afriLanguage`, `lastUpdate`, `lastUpdatedBy`)
VALUES ('QUOTATION', 'FULL_NAME', 'Full Name', 'Full Name', 'Volle naam', now(), 1);
END IF;

IF NOT EXISTS(select * from ui_translation where  objectName = "QUOTATION" and keyName = "NO_RECORD_FOUND") THEN
INSERT INTO ui_translation (`objectName`, `keyName`, `defaultValue`, `customerDefineValue`, `afriLanguage`, `lastUpdate`, `lastUpdatedBy`)
VALUES ('QUOTATION', 'NO_RECORD_FOUND', 'No record found', 'No record found', 'Geen rekord gevind nie', now(), 1);
END IF;


IF NOT EXISTS(select * from ui_translation where  objectName = "QUOTATION" and keyName = "ROOM_TYPE_IS_REQUIRED") THEN
 INSERT INTO ui_translation (`objectName`, `keyName`, `defaultValue`, `customerDefineValue`, `afriLanguage`, `lastUpdate`, `lastUpdatedBy`)
VALUES ('QUOTATION', 'ROOM_TYPE_IS_REQUIRED', 'Room type is required', 'Room type is required', 'Kamertipe word vereis', now(), 1),
('QUOTATION', 'OPTIONAL_MODULE_IS_REQ', 'Optional Additional Module is required.', 'Optional Additional Module is required.', 'Opsionele Addisionele Module word vereis.', now(), 1),
 ('QUOTATION', 'MODULE_ATTEMPT_IS_REQ', 'Module Attempt is required.', 'Module Attempt is required.', 'Module-poging word vereis.', now(), 1),
 ('QUOTATION', 'MODULE_FEE_IS_REQ', 'Module Fee is required.', 'Module Fee is required.', 'Module Fooi word vereis.', now(), 1),
('QUOTATION', 'ADDITION_MODULE_SELECTION', 'Additional Module Selection extra module or modules in arrears', 'Additional Module Selection extra module or modules in arrears', 'Bykomende modulekeuse ekstra module of agterstallige modules', now(), 1),
('QUOTATION', 'EXTRA_MODULES', 'extra module or modules in arrears', 'extra module or modules in arrears', 'ekstra module of agterstallige modules', now(), 1),
('QUOTATION', 'GENDER_IS_REQUIRED', 'Gender is required', 'Gender is required', 'Geslag word vereis', now(), 1),
('QUOTATION', 'ID_TYPE_IS_REQUIRED', 'Id type is required', 'Id type is required', 'ID-tipe word vereis', now(), 1),
('QUOTATION', 'COUNTRY_OF_CITIZENSHIP_IS_REQUIRED', 'Country of citizenship is required', 'Country of citizenship is required', 'Land van burgerskap word vereis', now(), 1),
('QUOTATION', 'SECONDARY_CITIZENSHIP_IS_REQUIRED', 'Secondary citizenship of africa is required', 'Secondary citizenship of africa is required', 'Sekondêre burgerskap van Afrika word vereis', now(), 1),
('QUOTATION', 'ACCOMMODATION_IS_REQUIRED', 'Accommodation is required', 'Accommodation is required', 'Verblyf word vereis', now(), 1),
('QUOTATION', 'TITLE_IS_REQUIRED', 'Title is required', 'Title is required', 'Titel word vereis', now(), 1),
('QUOTATION', 'FULLNAME_IS_REQUIRED', 'Full name is required', 'Full name is required', 'Volle naam word vereis', now(), 1),
('QUOTATION', 'EMAIL_ADDRESS_IS_REQUIRED', 'Email address is required', 'Email address is required', 'E-posadres word vereis', now(), 1),
('QUOTATION', 'SU_NUMBER_IS_REQUIRED', 'Su number is required', 'Su number is required', 'Su-nommer word vereis', now(), 1),
('QUOTATION', 'ENTER_FULL_NAME', 'Enter Full Name', 'Enter Full Name', 'Voer volle naam in', now(), 1),
('QUOTATION', 'ENTER_SU_NUMBER', 'Enter SU Number', 'Enter SU Number', 'Voer US-nommer in', now(), 1),
('QUOTATION', 'ENTER_EMAIL_ADDRESS', 'Enter Email Address', 'Enter Email Address', 'Voer e-posadres in', now(), 1),
('QUOTATION', 'VAILD_EMAIL_ADDRESS', 'please enter valid email address', 'please enter valid email address', 'Voer asseblief n geldige e-posadres in', now(), 1);
END IF;




SET SQL_SAFE_UPDATES=1;


END $$
CALL V20240723115606__Update_quotation_details_ui_translation () $$
DROP PROCEDURE IF EXISTS V20240723115606__Update_quotation_details_ui_translation $$
DELIMITER ;