DELIMITER $$
DROP PROCEDURE IF EXISTS V20240806113829__Insert_GovernmentSponsorCSM $$
CREATE PROCEDURE V20240806113829__Insert_GovernmentSponsorCSM()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='government_sponsor_csm')) THEN 
CREATE TABLE `government_sponsor_csm` (
	`id` BIGINT(20) NOT NULL AUTO_INCREMENT,  
	`itemCode` VARCHAR(255) NOT NULL,
	`itemValue` VARCHAR(255) NOT NULL,
	`sequenceNo` INT NOT NULL, 
	`governmentSponsorActive` BIT(1) NOT NULL DEFAULT b'1',
	`lastUpdatedBy` BIGINT(20) NOT NULL,
	`lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    PRIMARY KEY (`id`),
    KEY `fk_government_sponsor_csm_lastUpdatedBy_idx` (`lastUpdatedBy`),
	CONSTRAINT `fk_government_sponsor_csm_lastUpdatedBy` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`)
) ENGINE=InnoDB ;
END IF; 
	-- ------------------CSM DATA-------------------------------------------------
SET @currentTimeStamp = (SELECT CURRENT_TIMESTAMP);
SET @standardMasterMaxId=(SELECT MAX(id) FROM standard_master);

IF NOT EXISTS ((SELECT * FROM standard_master WHERE tableName = 'government_sponsor_csm')) THEN 
INSERT INTO `standard_master`(`id`,`childMaster`,`tableName`,`masterName`,`moduleName`,`filterCode`,`whetherChild`,`whetherParent`, `droolsAgenda`,`lastUpdatedBy`,`lastUpdate`) 
VALUES (@standardMasterMaxId+1, NULL,'government_sponsor_csm','GOVERNMENT_SPONSOR','Student Profile','COMMON_MASTER',0,0,NULL,1,@currentTimeStamp);
END IF; 


IF EXISTS ((SELECT * FROM standard_master WHERE tableName = 'government_sponsor_csm')) THEN 
SET @standardMasterId=(SELECT id FROM standard_master WHERE tableName = 'government_sponsor_csm');

INSERT INTO `standard_master_items` (`dbFieldName`,`fieldLabel`,`standardMasterId`,`fieldType`,`emunType`,`diaplayOrder`,`whetherForeignKey`,`fkTable`,`fkFieldName`,`fkDisplayField`,`whetherShortCode`,`whetherReadOnly`,`wheherNullable`,`validationType`,`maxLength`,`minLength`,`lastUpdatedBy`,`lastUpdate`)
VALUES ('code','ITEM_CODE',@standardMasterId,'Varchar',NULL,1,0,NULL,NULL,NULL,0,0,0,NULL,NULL,NULL,1,now());

INSERT INTO `standard_master_items` (`dbFieldName`,`fieldLabel`,`standardMasterId`,`fieldType`,`emunType`,`diaplayOrder`,`whetherForeignKey`,`fkTable`,`fkFieldName`,`fkDisplayField`,`whetherShortCode`,`whetherReadOnly`,`wheherNullable`,`validationType`,`maxLength`,`minLength`,`lastUpdatedBy`,`lastUpdate`)
VALUES ('value','ITEM_VALUE',@standardMasterId,'Varchar',NULL,2,0,NULL,NULL,NULL,0,0,0,NULL,NULL,NULL,1,now());

INSERT INTO `standard_master_items` (`dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`,`emunType`,`diaplayOrder`, `whetherForeignKey`,`fkTable`,`fkFieldName`,`fkDisplayField`,`whetherShortCode`, `whetherReadOnly`, `wheherNullable`,`lastUpdatedBy`, `lastUpdate`)
VALUES ('sequenceNo', 'SEQUENCE_NO', @standardMasterId,'Number',NULL,3,0,NULL,NULL,NULL,0,0,0,1,now());

INSERT INTO standard_master_items (`dbFieldName`,`fieldLabel`,`standardMasterId`,`fieldType`,`emunType`,`diaplayOrder`,`whetherForeignKey`,`fkTable`,`fkFieldName`,`fkDisplayField`,`whetherShortCode`,`whetherReadOnly`,`wheherNullable`,`lastUpdatedBy`,`lastUpdate`)
VALUES ('governmentSponsorActive','GOVERNMENT_SPONSOR_ACTIVE',@standardMasterId,'Boolean',NULL,4,0,NULL,NULL,NULL,0,0,0,1,now());
END IF; 

-- ------------------TRANSLATION-------------------------------------------------
IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE objectName = 'masterNames' AND keyName = 'GOVERNMENT_SPONSOR')) THEN 
INSERT INTO `ui_translation` (`objectName`, `keyName`, `defaultValue`, `customerDefineValue`,`afriLanguage`,`vietLanguage`,`lastUpdate`,`lastUpdatedBy`)
VALUES ('masterNames', 'GOVERNMENT_SPONSOR', 'Government Sponsor', 'Government Sponsor','Staatsborg','Nhà tài trợ chính phủ',now(),1);
END IF; 

END $$
CALL V20240806113829__Insert_GovernmentSponsorCSM() $$
DROP PROCEDURE IF EXISTS V20240806113829__Insert_GovernmentSponsorCSM $$
DELIMITER ;