DELIMITER $$
DROP PROCEDURE IF EXISTS V20240823162640__Update_dydt_data_line_item_seq_no $$
CREATE PROCEDURE V20240823162640__Update_dydt_data_line_item_seq_no()
BEGIN
SET SQL_SAFE_UPDATES=0;
IF EXISTS ((select * from dydt_data_line_item where dataSourceCode = "SEQUENCE_NUMBER")) THEN 
UPDATE dydt_data_line_item 
SET 
    sqlSelectQueryDef = 'SELECT 
        (CASE
            WHEN c.isSequenceRequired IS FALSE THEN NULL
            ELSE c2.sequenceNumber
        END) AS SEQUENCE_NUMBER
    FROM
        certificates c
            LEFT JOIN
        document_sequence c2 ON c2.certificateId = c.id'
WHERE
    dataSourceCode = 'SEQUENCE_NUMBER';
END IF; 
SET SQL_SAFE_UPDATES=1;
END $$
CALL V20240823162640__Update_dydt_data_line_item_seq_no () $$
DROP PROCEDURE IF EXISTS V20240823162640__Update_dydt_data_line_item_seq_no $$
DELIMITER ;