DELIMITER $$
DROP PROCEDURE IF EXISTS V20241001155100__Create_Standard_Payment_Gateway $$
CREATE PROCEDURE V20241001155100__Create_Standard_Payment_Gateway()
BEGIN
IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='standard_payment_gateway')) THEN 
CREATE TABLE `standard_payment_gateway` (
  `id` BIGINT(20) NOT NULL AUTO_INCREMENT,
  `itemCode` VARCHAR(255) NOT NULL,
  `itemValue` VARCHAR(255) NOT  NULL,
  `activeStatus` Boolean DEFAULT false,
  `lastUpdatedBy` BIGINT(20) NOT NULL,
  `lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users`(`id`))
     ENGINE=INNODB DEFAULT 
     CHARSET=utf8; 
     SET @currentTimeStamp = (SELECT CURRENT_TIMESTAMP);
	SET @standardMasterMaxId=(SELECT MAX(id) FROM standard_master);
  INSERT INTO standard_master(`id`,`tableName`, `masterName`, `moduleName`, `filterCode`, `whetherChild`, `whetherParent`, `lastUpdatedBy`, `lastUpdate`) 
  VALUES (@standardMasterMaxId+1,'standard_payment_gateway', 'STANDARD_PAYMENT_GATEWAY', 'Payment Gateway', 'MASTER_WITH_AL', 0, 0, '1', SYSDATE());
SET @ItemsMaxId=(SELECT MAX(id) FROM standard_master_items);
INSERT INTO standard_master_items(`id`, `dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`, `diaplayOrder`, `whetherForeignKey`, `whetherShortCode`, `whetherReadOnly`, `wheherNullable`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@ItemsMaxId + 1, 'itemCode', 'ITEM_CODE', @standardMasterMaxId + 1, 'varchar', '1', 0, 0, 0, 0, '1', NOW());
SET @ItemsMaxId=(SELECT MAX(id) FROM standard_master_items);
INSERT INTO standard_master_items(`id`, `dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`, `diaplayOrder`, `whetherForeignKey`, `whetherShortCode`, `whetherReadOnly`, `wheherNullable`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@ItemsMaxId + 1, 'itemValue', 'ITEM_VALUE', @standardMasterMaxId + 1, 'varchar', '2', 0, 0, 0, 0, '1', NOW());
SET @ItemsMaxId=(SELECT MAX(id) FROM standard_master_items);
INSERT INTO standard_master_items(`id`, `dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`, `diaplayOrder`, `whetherForeignKey`, `whetherShortCode`, `whetherReadOnly`, `wheherNullable`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@ItemsMaxId + 1, 'activeStatus', 'ACTIVE_STATUS', @standardMasterMaxId + 1, 'boolean', '3', 0, 0, 0, 1, '1', NOW());

INSERT INTO standard_payment_gateway (itemCode,itemValue,activeStatus,lastUpdate,lastUpdatedBy)  VALUES ('Flywire','Flywire',false,now(),1);
INSERT INTO standard_payment_gateway (itemCode,itemValue,activeStatus,lastUpdate, lastUpdatedBy)  VALUES ('Network','Network',false,now(),1);
INSERT INTO standard_payment_gateway (itemCode,itemValue,activeStatus,lastUpdate, lastUpdatedBy)  VALUES ('Stripe','Stripe',false,now(),1);
END IF; 

END $$
CALL V20241001155100__Create_Standard_Payment_Gateway () $$ 
DROP PROCEDURE IF EXISTS V20241001155100__Create_Standard_Payment_Gateway $$ 
DELIMITER ;