DELIMITER $$
DROP PROCEDURE IF EXISTS V20241003151124__Create_Flywire_ChildCSM $$
CREATE PROCEDURE V20241003151124__Create_Flywire_ChildCSM()
BEGIN

IF NOT EXISTS (((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='flywire'))) THEN
CREATE TABLE `flywire` (
  `id` BIGINT(20) NOT NULL AUTO_INCREMENT,
  `standardPaymentGatewayId` BIGINT(20) NULL,
        `academyLocation` varchar(255) NOT NULL,
        `payerId` bigint(20) NOT NULL,
  `recipient` varchar(255) NOT NULL,
        `environment` varchar(255) NOT NULL,
        `orderUrl` varchar(255) NOT NULL,
        `country` varchar(255) NOT NULL,
        `state` varchar(255) NOT NULL,
        `xAuthenticationKey` varchar(255) NOT NULL,
        `locale` varchar(255) NOT NULL,
        `provider` varchar(255) NOT NULL,
`lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
`lastUpdatedBy` bigint(20) NOT NULL,
PRIMARY KEY (`id`),
INDEX `fk_flywire_id_idx` (`standardPaymentGatewayId` ASC),
INDEX `fk_flywire_lastUpdatedBy_user_id_idx` (`lastUpdatedBy` ASC),
  CONSTRAINT `fk_flywire_id_idx`
   FOREIGN KEY (`standardPaymentGatewayId`)
   REFERENCES `standard_payment_gateway` (`id`)
   ON DELETE RESTRICT
   ON UPDATE RESTRICT,
  CONSTRAINT `fk_flywire_lastUpdatedBy_user_id_idx`
   FOREIGN KEY (`lastUpdatedBy`)
   REFERENCES `users` (`id`)
   ON DELETE RESTRICT
   ON UPDATE RESTRICT
) ;
END IF;

IF NOT EXISTS ((SELECT * FROM standard_master WHERE tableName = 'flywire')) THEN
SET @standardMasterMaxId=(SELECT MAX(id) FROM standard_master);
INSERT INTO `standard_master`(`id`,`tableName`, `masterName`, `moduleName`, `filterCode`, `whetherChild`, `whetherParent`, `lastUpdatedBy`,`lastUpdate`)
VALUES (@standardMasterMaxId+1, 'flywire','FLYWIRE','Fees & Payments','COMMON_MASTER',1,0,1,SYSDATE());

SET SQL_SAFE_UPDATES = 0;
SET @standardMasterId=(SELECT id FROM standard_master WHERE `tableName`='flywire');
UPDATE `standard_master` SET `childMaster`=@standardMasterId, `whetherParent`=1 WHERE `tableName`='standard_payment_gateway';
UPDATE  `standard_payment_gateway` SET `itemCode` = @standardMasterId WHERE (itemValue = 'flywire');
SET SQL_SAFE_UPDATES = 1;


   SET @ItemsMaxId=(SELECT MAX(id) FROM standard_master_items);
INSERT INTO `standard_master_items`(`id`, `dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`, `diaplayOrder`, `whetherForeignKey`, `whetherShortCode`, `whetherReadOnly`, `wheherNullable`, `lastUpdatedBy`,`lastUpdate`)
VALUES (@ItemsMaxId+1, 'academyLocation', 'Academy Location', @standardMasterMaxId+1, 'Varchar', '1', 0, 0, 0, 0, '1',SYSDATE());
       
SET @ItemsMaxId=(SELECT MAX(id) FROM standard_master_items);
INSERT INTO `standard_master_items`(`id`, `dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`, `diaplayOrder`, `whetherForeignKey`, `whetherShortCode`, `whetherReadOnly`, `wheherNullable`, `lastUpdatedBy`,`lastUpdate`)
VALUES (@ItemsMaxId+1, 'payerId', 'Payer ID', @standardMasterMaxId+1, 'number', '2', 0, 0, 0, 0, '1',SYSDATE());
       
SET @ItemsMaxId=(SELECT MAX(id) FROM standard_master_items);
INSERT INTO `standard_master_items`(`id`, `dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`, `diaplayOrder`, `whetherForeignKey`, `whetherShortCode`, `whetherReadOnly`, `wheherNullable`, `lastUpdatedBy`,`lastUpdate`)
VALUES (@ItemsMaxId+1, 'recipient', 'Recipient', @standardMasterMaxId+1, 'Varchar', '3', 0, 0, 0, 0, '1',SYSDATE());
       
SET @ItemsMaxId=(SELECT MAX(id) FROM standard_master_items);
INSERT INTO `standard_master_items`(`id`, `dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`, `diaplayOrder`, `whetherForeignKey`, `whetherShortCode`, `whetherReadOnly`, `wheherNullable`, `lastUpdatedBy`,`lastUpdate`)
VALUES (@ItemsMaxId+1, 'environment', 'Environment', @standardMasterMaxId+1, 'Varchar', '4', 0, 0, 0, 0, '1',SYSDATE());
       
SET @ItemsMaxId=(SELECT MAX(id) FROM standard_master_items);
INSERT INTO `standard_master_items`(`id`, `dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`, `diaplayOrder`, `whetherForeignKey`, `whetherShortCode`, `whetherReadOnly`, `wheherNullable`, `lastUpdatedBy`,`lastUpdate`)
VALUES (@ItemsMaxId+1, 'orderUrl', 'OrderUrl', @standardMasterMaxId+1, 'Varchar', '5', 0, 0, 0, 0, '1',SYSDATE());
       
SET @ItemsMaxId=(SELECT MAX(id) FROM standard_master_items);
INSERT INTO `standard_master_items`(`id`, `dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`, `diaplayOrder`, `whetherForeignKey`, `whetherShortCode`, `whetherReadOnly`, `wheherNullable`, `lastUpdatedBy`,`lastUpdate`)
VALUES (@ItemsMaxId+1, 'country', 'Country', @standardMasterMaxId+1, 'Varchar', '6', 0, 0, 0, 0, '1',SYSDATE());
       
SET @ItemsMaxId=(SELECT MAX(id) FROM standard_master_items);
INSERT INTO `standard_master_items`(`id`, `dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`, `diaplayOrder`, `whetherForeignKey`, `whetherShortCode`, `whetherReadOnly`, `wheherNullable`, `lastUpdatedBy`,`lastUpdate`)
VALUES (@ItemsMaxId+1, 'state', 'State', @standardMasterMaxId+1, 'Varchar', '7', 0, 0, 0, 0, '1',SYSDATE());
       
SET @ItemsMaxId=(SELECT MAX(id) FROM standard_master_items);
INSERT INTO `standard_master_items`(`id`, `dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`, `diaplayOrder`, `whetherForeignKey`, `whetherShortCode`, `whetherReadOnly`, `wheherNullable`, `lastUpdatedBy`,`lastUpdate`)
VALUES (@ItemsMaxId+1, 'xAuthenticationKey', 'X-Authentication-Key', @standardMasterMaxId+1, 'Varchar', '8', 0, 0, 0, 0, '1',SYSDATE());
       
   SET @ItemsMaxId=(SELECT MAX(id) FROM standard_master_items);
INSERT INTO `standard_master_items`(`id`, `dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`, `diaplayOrder`, `whetherForeignKey`, `whetherShortCode`, `whetherReadOnly`, `wheherNullable`, `lastUpdatedBy`,`lastUpdate`)
VALUES (@ItemsMaxId+1, 'locale', 'Locale', @standardMasterMaxId+1, 'Varchar', '9', 0, 0, 0, 0, '1',SYSDATE());
       
SET @ItemsMaxId=(SELECT MAX(id) FROM standard_master_items);
INSERT INTO `standard_master_items`(`id`, `dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`, `diaplayOrder`, `whetherForeignKey`, `whetherShortCode`, `whetherReadOnly`, `wheherNullable`, `lastUpdatedBy`,`lastUpdate`)
VALUES (@ItemsMaxId+1, 'provider', 'Provider', @standardMasterMaxId+1, 'Varchar', '10', 0, 0, 0, 0, '1',SYSDATE());

END IF; 

END $$
CALL V20241003151124__Create_Flywire_ChildCSM () $$ 
DROP PROCEDURE IF EXISTS V20241003151124__Create_Flywire_ChildCSM $$ 
DELIMITER ;