DELIMITER $$
DROP PROCEDURE IF EXISTS V20241003182854__Create_TransferCreditStatus $$
CREATE PROCEDURE V20241003182854__Create_TransferCreditStatus()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.TABLES WHERE table_schema=DATABASE() AND table_name='transfer_credit_status')) THEN 
CREATE TABLE `transfer_credit_status`(
	`id` BIGINT(20) NOT NULL AUTO_INCREMENT,  
	`evaluationPlanRankId` BIGINT(20) DEFAULT NULL,
    	`mainCourseId` BIGINT(20) DEFAULT NULL,
	`equivalenceCourseId` BIGINT(20) DEFAULT NULL,
	`status` VARCHAR(255) DEFAULT NULL,
    	`lastUpdatedBy` BIGINT(20) NOT NULL,
	`lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
	PRIMARY KEY (`id`),
	FOREIGN KEY (`evaluationPlanRankId`) REFERENCES `evaluation_plan_rank`(`id`),
    	FOREIGN KEY (`mainCourseId`) REFERENCES `courses`(`id`),
	FOREIGN KEY (`equivalenceCourseId`) REFERENCES `courses`(`id`),
	FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users`(`id`)
    );
END IF; 
 

END $$
CALL V20241003182854__Create_TransferCreditStatus () $$ 
DROP PROCEDURE IF EXISTS V20241003182854__Create_TransferCreditStatus $$ 
DELIMITER ;