DELIMITER $$
DROP PROCEDURE IF EXISTS V20241005191016__Create_EscalatedAfterAcceptanceEvent $$
CREATE PROCEDURE V20241005191016__Create_EscalatedAfterAcceptanceEvent()
BEGIN

IF NOT EXISTS ((SELECT * FROM system_msg_event where code='ESCALATION_AFTER_ACCEPTANCE')) THEN 
-- =======================Messaging event: ESCALATION_AFTER_ACCEPTANCE=============================================
SET @parentcategoryId=(SELECT id FROM msg_category WHERE `code`='ADMISSION');
SET @msgcategoryId=(SELECT MAX(id) FROM msg_category);
INSERT INTO `msg_category` (`id`,`parentCategory`,`code`) VALUES (@msgcategoryId+1,@parentcategoryId,'ESCALATION_AFTER_ACCEPTANCE'); 

SET @systemmsgeventId=(SELECT MAX(id) FROM system_msg_event);
SET @msgSubCategoryId=(SELECT id FROM msg_category WHERE `code`='ESCALATION_AFTER_ACCEPTANCE');

INSERT INTO `system_msg_event` (`id`, `msgConfigLevelId`, `msgSubCategoryId`, `code`, `displayCode`, `eventType`, `whetherRepetationApplicable`, `whetherInitiationRuleApplicable`, `whetherScheduledEvent`, `whetherMsgScopeApplicable`, `whetherImplicitDistributionList`, `whetherDistributionRuleApplicable`, `whetherCommonMsgTemplate`, `description`) 
VALUES (@systemmsgeventId+1, '1', @msgSubCategoryId, 'ESCALATION_AFTER_ACCEPTANCE', 'Escalated After Acceptance', 'SYSTEM', 0, 0, 0, 0, 1, 0, 0, 'Escalated After Acceptance');

SET @sysmsgevtdefaultconfId=(SELECT MAX(id) FROM sys_msg_evt_default_conf);
INSERT INTO `sys_msg_evt_default_conf` (`id`, `systemMsgEventId`, `msgTemplateConfigId`, `initiationRuleProviderId`, `sendingPriority`) 
VALUES (@sysmsgevtdefaultconfId+1, @systemmsgeventId+1, NULL, NULL, 'IMMEDIATE');

SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='CONTEXT_RECORD_ID');
INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) 
VALUES (@sysmsgevtdefaultscopeId+1, @sysmsgevtdefaultconfId+1, @msgScopeParamId);

SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='EVENT_TRIGGER_DATE');
INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1, @sysmsgevtdefaultconfId+1, @msgScopeParamId);

SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='CONFIG_LEVEL_VALUE');
INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1, @sysmsgevtdefaultconfId+1, @msgScopeParamId);

SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='ACADEMY_LOCATION_IDS');
INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1	, @sysmsgevtdefaultconfId+1, @msgScopeParamId);

SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='EXTRA_PARAMS');
INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1	, @sysmsgevtdefaultconfId+1, @msgScopeParamId);

SET @dtproviderId=(SELECT MAX(id) FROM dtprovider);
INSERT INTO `dtprovider` (`id`, `dataProviderName`, `dataProviderType`) VALUES (@dtproviderId+1, 'ESCALATION_AFTER_ACCEPTANCE_DL', 'SQL');

SET @dtproviderId=(SELECT MAX(id) FROM dtprovider);
INSERT INTO `dtprovider` (`id`, `dataProviderName`, `dataProviderType`) VALUES (@dtproviderId+1, 'ESCALATION_AFTER_ACCEPTANCE_RECIPIENTS', 'SQL');

SET @msgRecipientId=(SELECT MAX(id) FROM msg_recipient_type);
SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='ESCALATION_AFTER_ACCEPTANCE_RECIPIENTS');
INSERT INTO `msg_recipient_type` (`id`, `recipientDataProviderId`, `code`) VALUES (@msgRecipientId+1, @dtproviderId, 'ESCALATION_AFTER_ACCEPTANCE_RECIPIENTS');

SET @sysmsgevtrcptdefaultconfId=(SELECT MAX(id) FROM `sys_msg_evtrcpt_default_conf`);
SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='ESCALATION_AFTER_ACCEPTANCE_DL');
SET @recipientTypeId=(SELECT id FROM `msg_recipient_type` WHERE `code`='ESCALATION_AFTER_ACCEPTANCE_RECIPIENTS');
INSERT INTO `sys_msg_evtrcpt_default_conf` (`id`, `sysMsgEvtDefaultConfId`, `distrListProviderId`, `distrRuleProviderId`, `recipientTypeId`) VALUES (@sysmsgevtrcptdefaultconfId+1, @sysmsgevtdefaultconfId+1, @dtproviderId, NULL, @recipientTypeId);

SET @sqlDtproviderId=(SELECT MAX(id) FROM `sql_dtprovider`);
SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='ESCALATION_AFTER_ACCEPTANCE_DL');
INSERT INTO `sql_dtprovider` (`id`, `dataProviderId`, `sqlQuery`, `jsonString`) VALUES (@sqlDtproviderId+1,@dtproviderId,"select T1.id as USER_ID from app_program_adm_details T1 where T1.id = (namedParams)",NULL);

SET @sqlDtproviderId=(SELECT MAX(id) FROM `sql_dtprovider`);
SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='ESCALATION_AFTER_ACCEPTANCE_RECIPIENTS');
INSERT INTO `sql_dtprovider` (`id`, `dataProviderId`,`sqlQuery`, `jsonString`) 
VALUES (@sqlDtproviderId+1,@dtproviderId,"SELECT 
    T1.id AS ID,
    T6.code AS APPLICATION_CODE,
	T6.currentStatus AS APPLICATION_STATUS,
	T10.printName AS USER_PRINT_NAME,
    T7.firstName AS FIRST_NAME,
    T7.lastName AS LAST_NAME,
    T7.printName AS APPLICANT_NAME,
    T1.escalatedDate AS ESCALATED_RE_ASSIGN_DATE,
    T1.escalationComments AS ESCALATION_RE_ASSIGN_REMARK,   
    T10.emailId AS EMAIL_ID,
    T4.programName AS PROGRAM_NAME,
    T8.batchName AS BATCH_PRINT_NAME,
    T9.seatName AS SEAT_TYPE,
    T5.academyName AS ACADEMY_NAME,
    T5.locationName AS LOCATION_NAME,
    T5.displayName AS ACADEMY_NAME_LOCATION,    
    (CASE
        WHEN
            T5.headerUrl IS NOT NULL
                AND org.orgUrl IS NOT NULL
        THEN
            CONCAT(org.orgUrl, '/', T5.headerUrl)
        ELSE NULL
    END) AS HEADER_URL,
    (CASE
        WHEN
            T5.footerUrl IS NOT NULL
                AND org.orgUrl IS NOT NULL
        THEN
            CONCAT(org.orgUrl, '/', T5.footerUrl)
        ELSE NULL
    END) AS FOOTER_URL,
    (CASE
        WHEN
            T5.logoUrl IS NULL
                AND org.orgUrl IS NOT NULL
        THEN
            CONCAT(org.orgUrl,
                    '/',
                    'emailer/images/logo_default_image.png')
        WHEN
            T5.logoUrl IS NULL
                AND org.orgUrl IS NULL
        THEN
            'https://www.serosoft.com/mailer/academiaerp_logo_red.png'
        ELSE CONCAT(org.orgUrl, '/', T5.logoUrl)
    END) AS LOGO_URL
FROM
    app_program_adm_details T1
        LEFT OUTER JOIN
    application_program T2 ON T1.applicationProgramId = T2.id
        LEFT OUTER JOIN
    prog_batch_seat_config T3 ON T2.progBatchSeatConfigId = T3.id
        LEFT OUTER JOIN
    programs T4 ON T2.programId = T4.id
        LEFT OUTER JOIN
    academy_location T5 ON T2.academyLocationId = T5.id
        LEFT OUTER JOIN
    application T6 ON T2.applicationId = T6.id
        LEFT OUTER JOIN
    applicant_person T7 ON T6.applicantPersonId = T7.id
        LEFT OUTER JOIN
    batches T8 ON T8.id = T3.programBatchId
        LEFT OUTER JOIN
    seat_types T9 ON T9.id = T3.seatTypeId
        LEFT OUTER JOIN
    users T10 ON T1.reviewerId = T10.id
        LEFT OUTER JOIN
    organizations org ON org.id = (SELECT 
            MAX(id)
        FROM
            organizations)
WHERE
    T1.id IN (namedParams);",'{
    "id": 1,
    "searchResultViewColumns": [
        {
            "id": 1,
            "value": "escalatedDate",
            "resultKey": "ESCALATED_RE_ASSIGN_DATE",
            "displayCode": "",
            "displayOrder": 0
        },
		{
            "id": 2,
            "value": "escalationComments",
            "resultKey": "ESCALATION_RE_ASSIGN_REMARK",
            "displayCode": "",
            "displayOrder": 1
        },
        {
            "id": 3,
            "value": "code",
            "resultKey": "APPLICATION_CODE",
            "displayCode": "",
            "displayOrder": 2
        },
		 {
            "id": 4,
            "value": "firstName",
            "resultKey": "FIRST_NAME",
            "displayCode": "",
            "displayOrder": 3
        },
		 {
            "id": 5,
            "value": "lastName",
            "resultKey": "LAST_NAME",
            "displayCode": "",
            "displayOrder": 4
        },	
        {
            "id": 6,
            "value": "printName",
            "resultKey": "APPLICANT_NAME",
            "displayCode": "",
            "displayOrder": 5
        },
		{
            "id": 7,
            "value": "emailId",
            "resultKey": "EMAIL_ID",
            "displayCode": "",
            "displayOrder": 6
        },
		{
            "id": 8,
            "value": "programName",
            "resultKey": "PROGRAM_NAME",
            "displayCode": "",
            "displayOrder": 7
        },
		{
            "id": 9,
            "value": "batchName",
            "resultKey": "BATCH_PRINT_NAME",
            "displayCode": "",
            "displayOrder": 8
        },
		{
            "id": 10,
            "value": "seatName",
            "resultKey": "SEAT_TYPE",
            "displayCode": "",
            "displayOrder": 9
        },
		{
            "id": 11,
            "value": "academyName",
            "resultKey": "ACADEMY_NAME",
            "displayCode": "",
            "displayOrder": 10
        },
		{
            "id": 12,
            "value": "locationName",
            "resultKey": "LOCATION_NAME",
            "displayCode": "",
            "displayOrder": 11
        },
		{
            "id": 13,
            "value": "displayName",
            "resultKey": "ACADEMY_NAME_LOCATION",
            "displayCode": "",
            "displayOrder": 12
        },		
		{
            "id": 14,
            "value": "headerURL",
            "resultKey": "HEADER_URL",
            "displayCode": "",
            "displayOrder": 13
        },
		{
            "id": 15,
            "value": "footerURL",
            "resultKey": "FOOTER_URL",
            "displayCode": "",
            "displayOrder": 14
        },
		{
            "id": 16,
            "value": "logoURL",
            "resultKey": "LOGO_URL",
            "displayCode": "",
            "displayOrder": 15
        },
		{
            "id": 17,
            "value": "printName",
            "resultKey": "USER_PRINT_NAME",
            "displayCode": "",
            "displayOrder": 16
        }
    ]
}');


SET @dtprvdrinputparamId=(SELECT MAX(id) FROM dtprvdr_input_param);
SET @dtproviderId=(SELECT id FROM `dtprovider` where `dataProviderName`='ESCALATION_AFTER_ACCEPTANCE_DL');
SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='CONFIG_LEVEL_VALUE');
INSERT INTO `dtprvdr_input_param` (`id`, `dataProviderId`, `paramName`, `paramDataType`, `paramType`, `msgScopeParamId`, `operatorCode`, `additionalInputParamId`) 
VALUES(@dtprvdrinputparamId+1,@dtproviderId,'T1.id','NUMBER_EQUAL','SCOPEPARAM',@msgScopeParamId,'NUMBER_EQUAL',NULL);

SET @msgtemplateId=(SELECT MAX(id) FROM msg_template);
SET @sysMsgEventId=(SELECT id FROM system_msg_event where code='ESCALATION_AFTER_ACCEPTANCE');

SET @msgtemplateconfigId=(SELECT MAX(id) FROM msg_template_config);
SET @msgSubCategoryId=(SELECT id FROM `msg_category` WHERE `code`='ESCALATION_AFTER_ACCEPTANCE');
SET @recipientTypeId=(SELECT id FROM `msg_recipient_type` WHERE `code`='ESCALATION_AFTER_ACCEPTANCE_RECIPIENTS');
SET @msgMessageTypeId=(SELECT id FROM `msg_message_type` WHERE `code`='Notifications');


INSERT INTO `msg_template_config` (`id`, `code`, `msgSubCategoryId`, `sysMsgEventId`, `recipientTypeId`, `msgMessageTypeId`, `templateDataProviderId`, `templateConfigType`, `templateConfigName`, `whetherBulkMesaging`, `approvalRequired`, `approverId`, `whetherStaticMsg`, `status`, `availableForAdhocMsg`, `academyLocationId`, `authorName`, `authorId`,`whetherEnabled`,`templatelanguageValue`) 
VALUES(@msgtemplateconfigId+1,'Escalated After Acceptance',@msgSubCategoryId,@sysMsgEventId,@recipientTypeId,4,NULL,NULL,'Escalated After Acceptance',NULL,'',NULL,'','APPROVED','','1','System Admin System Admin','1',1,'English');

INSERT INTO `msg_template` (`id`, `msgTemplateConfigId`, `msgDeliveryModeId`, `subjectLine`, `msgContent`) 
VALUES (@msgtemplateId+1,@msgtemplateconfigId+1,'1','Escalated After Acceptance','<html>
<head>
	<title></title>
</head>
<body>
<div style="display: none;">&nbsp;</div>

<table align="center" style="min-width:700px; max-width:800px; border-collapse:collapse">
	<tbody>
		<tr style="background-color:#f0f0f0; line-height:20px;">
			<td style="padding:20px 20px 20px 20px;">
			<p style="font-family:sans-serif, Arial, Helvetica; font-size:12px">Dear&nbsp;$recipientData[&quot;USER_PRINT_NAME&quot;]</p>
			
			<p style="font-family:sans-serif, Arial, Helvetica; font-size:12px">The Escalated application $recipientData[&quot;APPLICATION_CODE&quot;] has been assigned to you on $recipientData[&quot;ESCALATED_RE_ASSIGN_DATE&quot;] with below Reasons:</p>

			<p style="font-family:sans-serif, Arial, Helvetica; font-size:12px">$recipientData[&quot;ESCALATION_RE_ASSIGN_REMARK&quot;]</p>
            
            <p style="font-family:sans-serif, Arial, Helvetica; font-size:12px">Regards</p>
			</td>
		</tr>	
	</tbody>
</table>
</body>
</html>');

INSERT INTO `msg_template` (`id`, `msgTemplateConfigId`, `msgDeliveryModeId`, `subjectLine`, `msgContent`) 
VALUES (@msgtemplateId+2,@msgtemplateconfigId+1,'4','Escalated After Acceptance','<html>
<head>
	<title></title>
</head>
<body>
<div style="display: none;">&nbsp;</div>

<table align="center" style="min-width:700px; max-width:800px; border-collapse:collapse">
	<tbody>
		<tr style="background-color:#f0f0f0; line-height:20px;">
			<td style="padding:20px 20px 20px 20px;">
			<p style="font-family:sans-serif, Arial, Helvetica; font-size:12px">Dear&nbsp;$recipientData[&quot;USER_PRINT_NAME&quot;]</p>
			
			<p style="font-family:sans-serif, Arial, Helvetica; font-size:12px">The Escalated application $recipientData[&quot;APPLICATION_CODE&quot;] has been assigned to you on $recipientData[&quot;ESCALATED_RE_ASSIGN_DATE&quot;] with below Reasons:</p>

			<p style="font-family:sans-serif, Arial, Helvetica; font-size:12px">$recipientData[&quot;ESCALATION_RE_ASSIGN_REMARK&quot;]</p>
            
            <p style="font-family:sans-serif, Arial, Helvetica; font-size:12px">Regards</p>
			</td>
		</tr>	
	</tbody>
</table>
</body>
</html>');

INSERT INTO `msg_template` (`id`, `msgTemplateConfigId`, `msgDeliveryModeId`, `subjectLine`, `msgContent`) 
VALUES (@msgtemplateId+3,@msgtemplateconfigId+1,'2',NULL,'Dear $recipientData[&quot;USER_PRINT_NAME&quot;], The Escalated Application $recipientData[&quot;APPLICATION_CODE&quot;] has been assigned to you on $recipientData[&quot;ESCALATED_RE_ASSIGN_DATE&quot;] with below Reasons: $recipientData[&quot;ESCALATED_RE_ASSIGN_REMARK&quot;]');

END IF; 
 

END $$
CALL V20241005191016__Create_EscalatedAfterAcceptanceEvent () $$ 
DROP PROCEDURE IF EXISTS V20241005191016__Create_EscalatedAfterAcceptanceEvent $$ 
DELIMITER ;