DELIMITER $$
DROP PROCEDURE IF EXISTS V20241108180710__Delete_Stud_Promotion_Stus_Chge_Job_Hide $$
CREATE PROCEDURE V20241108180710__Delete_Stud_Promotion_Stus_Chge_Job_Hide()
BEGIN

set sql_safe_updates=0;

IF EXISTS (select * from information_schema.tables where table_schema=database() and table_name='QRTZ_CRON_TRIGGERS') THEN
        -- Perform the delete if the record exists
        DELETE FROM QRTZ_CRON_TRIGGERS 
        WHERE SCHED_NAME = 'stdScheduler' 
          AND TRIGGER_NAME = 'studentPromotionStatusChangeJobTrigger' 
          AND TRIGGER_GROUP = 'DEFAULT';
END IF;

IF EXISTS (select * from information_schema.tables where table_schema=database() and table_name='QRTZ_TRIGGERS') THEN
        -- Perform the delete if the record exists
        DELETE FROM QRTZ_TRIGGERS 
        WHERE SCHED_NAME = 'stdScheduler' 
          AND JOB_NAME = 'Student Promotion Status Change' 
          AND JOB_GROUP = 'DEFAULT';
END IF;

IF EXISTS (select * from information_schema.tables where table_schema=database() and table_name='QRTZ_JOB_DETAILS') THEN
        -- Perform the delete if the record exists
        DELETE FROM QRTZ_JOB_DETAILS 
        WHERE SCHED_NAME = 'stdScheduler' 
          AND JOB_NAME = 'Student Promotion Status Change' 
          AND JOB_GROUP = 'DEFAULT';
END IF;

IF EXISTS (select * from information_schema.tables where table_schema=database() and table_name='qrtz_cron_triggers') THEN
        -- Perform the delete if the record exists
        DELETE FROM qrtz_cron_triggers 
        WHERE SCHED_NAME = 'stdScheduler' 
          AND TRIGGER_NAME = 'studentPromotionStatusChangeJobTrigger' 
          AND TRIGGER_GROUP = 'DEFAULT';
END IF;

IF EXISTS (select * from information_schema.tables where table_schema=database() and table_name='qrtz_triggers') THEN
        -- Perform the delete if the record exists
        DELETE FROM qrtz_triggers 
        WHERE SCHED_NAME = 'stdScheduler' 
          AND JOB_NAME = 'Student Promotion Status Change' 
          AND JOB_GROUP = 'DEFAULT';
END IF;

IF EXISTS (select * from information_schema.tables where table_schema=database() and table_name='qrtz_job_details') THEN
        -- Perform the delete if the record exists
        DELETE FROM qrtz_job_details 
        WHERE SCHED_NAME = 'stdScheduler' 
          AND JOB_NAME = 'Student Promotion Status Change' 
          AND JOB_GROUP = 'DEFAULT';
END IF;

set sql_safe_updates=1;
END $$
CALL V20241108180710__Delete_Stud_Promotion_Stus_Chge_Job_Hide() $$
DROP PROCEDURE IF EXISTS V20241108180710__Delete_Stud_Promotion_Stus_Chge_Job_Hide $$
DELIMITER ;