DELIMITER $$
DROP PROCEDURE IF EXISTS V20241129155210__Create_exam_external_invigilator_master $$
CREATE PROCEDURE V20241129155210__Create_exam_external_invigilator_master()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='exam_external_invigilator_master_data')) THEN 
CREATE TABLE `exam_external_invigilator_master_data`(
	`id` BIGINT(20) NOT NULL AUTO_INCREMENT,  
	`position` varchar(100) NULL DEFAULT NULL,
	`gender` VARCHAR(45) NULL DEFAULT NULL,
    `firstName` VARCHAR(255) NULL DEFAULT NULL,
    `lastName` VARCHAR(255) NULL DEFAULT NULL,
    `nationality` VARCHAR(45) NULL DEFAULT NULL,
    `identificationNumber` VARCHAR(45) NULL DEFAULT NULL,
    `emailId` VARCHAR(45) NULL DEFAULT NULL,
    `address` VARCHAR(512) NULL DEFAULT NULL,
    `race` VARCHAR(20) NULL DEFAULT NULL,
    `highestEducationQualification` VARCHAR(45) NULL DEFAULT NULL,
    `status` BIT(1) NOT NULL DEFAULT b'0',	
    `lastUpdatedBy` BIGINT(20) NOT NULL,
	`lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
	PRIMARY KEY (`id`),
	INDEX `invigilator_idx` (`lastUpdatedBy` ASC),
	CONSTRAINT `fk_invigilator` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users`(`id`)
    );
END IF; 

END $$
CALL V20241129155210__Create_exam_external_invigilator_master () $$ 
DROP PROCEDURE IF EXISTS V20241129155210__Create_exam_external_invigilator_master $$ 
DELIMITER ;