DELIMITER $$
DROP PROCEDURE IF EXISTS V20241217172330__Update_manage_promotion $$
CREATE PROCEDURE V20241217172330__Update_manage_promotion()
BEGIN
SET SQL_SAFE_UPDATES=0;
IF EXISTS (SELECT id from dtprovider where dataProviderName = 'PROMOTION_STATUS_UPDATE_RECIPIENT') THEN 
SET @dtproviderId = (SELECT id from dtprovider where dataProviderName = 'PROMOTION_STATUS_UPDATE_RECIPIENT');

UPDATE sql_dtprovider SET sqlQuery = "
SELECT DISTINCT
    T1.id AS ID,
    T9.code AS PROMOTION_STUDENT_ID,
    T10.firstName AS FIRST_NAME,
    T10.middleName AS MIDDLE_NAME,
    T10.lastName AS LAST_NAME,
    T10.printName AS PRINT_NAME,
    T10.emailId AS EMAIL_ID,
    T10.firstName AS PROMOTION_STUDENT_FIRST_NAME,
    T10.middleName AS PROMOTION_STUDENT_MIDDLE_NAME,
    T10.lastName AS PROMOTION_STUDENT_LAST_NAME,
    T10.printName AS PROMOTION_STUDENT_PRINT_NAME,
    T10.externalSysRefOne AS PROMOTION_EXTERNAL_REFERENCE_NUMBER_ONE,
    T11.salutationName AS PROMOTION_TITLE,
    T10.initials AS PROMOTION_INITIAL,
    T8.itemValue AS PROMOTION_ACADEMIC_TERM,
    T5.programNameToBePrint AS PROMOTION_PROGRAM,
    T4.printName AS PROMOTION_BATCH,
    T6.printName AS PROMOTION_PERIOD,
    T7.displayName AS PROMOTION_ACADEMY_LOCATION,
    T13.itemValue AS PROMOTION_STATUS,
    ml.code AS LANGUAGE_KEY,
    (SELECT 
            GROUP_CONCAT(DISTINCT deviceTokenId)
        FROM
            fire_base_persons_info
        WHERE
            fire_base_persons_info.userId = T5.id) AS DEVICE_ID,
    T10.mobileCountryCode AS MOBILE_CODE,
    T10.mobileNumber AS MOBILE_NO
FROM
    program_batch_students T1
        LEFT OUTER JOIN
    admission T2 ON T1.admissionId = T2.id
        LEFT OUTER JOIN
    students T3 ON T2.studentId = T3.userId
        LEFT OUTER JOIN
    batches T4 ON T1.programBatchId = T4.id
        LEFT OUTER JOIN
    programs T5 ON T4.programId = T5.id
        LEFT OUTER JOIN
    prog_batch_period_config T6 ON T1.progBatchPeriodConfigId = T6.id
        LEFT OUTER JOIN
    academy_location T7 ON T7.id = T5.academyLocationId
        LEFT OUTER JOIN
    academic_term T8 ON T8.id = T6.academicTermId
        LEFT OUTER JOIN
    users T9 ON T9.id = T3.userId
        LEFT OUTER JOIN
    persons T10 ON T10.id = T3.personId
        LEFT OUTER JOIN
    salutations T11 ON T11.id = T10.salutationId
        LEFT OUTER JOIN
    promotion T12 ON T12.fromRecordId = T1.id
        LEFT OUTER JOIN
    progression_status T13 ON T13.id = T12.progressionStatusId
        LEFT OUTER JOIN
    multi_language ml ON ml.id = T10.correspondence_language
        LEFT OUTER JOIN
    organizations org ON org.id = (SELECT 
            MAX(id)
        FROM
            organizations)
WHERE
    T1.isCurrentPeriod = TRUE
        AND T1.isCurrentSection = TRUE
        AND T1.exitDate IS NULL
        AND T13.allowCommunication = TRUE
        AND T1.id IN (namedParams)"
WHERE dataProviderId = @dtproviderId;
END IF; 
SET SQL_SAFE_UPDATES=1;
END $$
CALL V20241217172330__Update_manage_promotion () $$
DROP PROCEDURE IF EXISTS V20241217172330__Update_manage_promotion $$
DELIMITER ;