DELIMITER $$
DROP PROCEDURE IF EXISTS V20250220222030__Insert_Outcome $$
CREATE PROCEDURE V20250220222030__Insert_Outcome()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='outcome_csm')) THEN 
CREATE TABLE `outcome_csm` (
	`id` BIGINT(20) NOT NULL AUTO_INCREMENT,  
	`itemCode` VARCHAR(255) NOT NULL,
	`itemValue` VARCHAR(255) NOT NULL,
	`lastUpdatedBy` BIGINT(20) NOT NULL,
	`lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    PRIMARY KEY (`id`),
    KEY `fk_outcome_csm_lastUpdatedBy_idx` (`lastUpdatedBy`),
	CONSTRAINT `fk_outcome_csm_lastUpdatedBy` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`)
) ENGINE=InnoDB ;
END IF; 
	-- ------------------CSM DATA-------------------------------------------------
SET @currentTimeStamp = (SELECT CURRENT_TIMESTAMP);
SET @standardMasterMaxId=(SELECT MAX(id) FROM standard_master);

IF NOT EXISTS ((SELECT * FROM standard_master WHERE tableName = 'outcome_csm')) THEN 
INSERT INTO `standard_master`(`id`,`childMaster`,`tableName`,`masterName`,`moduleName`,`filterCode`,`whetherChild`,`whetherParent`, `droolsAgenda`,`lastUpdatedBy`,`lastUpdate`) 
VALUES (@standardMasterMaxId+1, NULL,'outcome_csm','OUTCOME','Student Profile','COMMON_MASTER',0,0,NULL,1,@currentTimeStamp);
END IF; 


IF EXISTS ((SELECT * FROM standard_master WHERE tableName = 'outcome_csm')) THEN 
SET @standardMasterId=(SELECT id FROM standard_master WHERE tableName = 'outcome_csm');

INSERT INTO `standard_master_items` (`dbFieldName`,`fieldLabel`,`standardMasterId`,`fieldType`,`emunType`,`diaplayOrder`,`whetherForeignKey`,`fkTable`,`fkFieldName`,`fkDisplayField`,`whetherShortCode`,`whetherReadOnly`,`wheherNullable`,`validationType`,`maxLength`,`minLength`,`lastUpdatedBy`,`lastUpdate`)
VALUES ('code','ITEM_CODE',@standardMasterId,'Varchar',NULL,1,0,NULL,NULL,NULL,0,0,0,NULL,NULL,NULL,1,now());

INSERT INTO `standard_master_items` (`dbFieldName`,`fieldLabel`,`standardMasterId`,`fieldType`,`emunType`,`diaplayOrder`,`whetherForeignKey`,`fkTable`,`fkFieldName`,`fkDisplayField`,`whetherShortCode`,`whetherReadOnly`,`wheherNullable`,`validationType`,`maxLength`,`minLength`,`lastUpdatedBy`,`lastUpdate`)
VALUES ('value','ITEM_VALUE',@standardMasterId,'Varchar',NULL,2,0,NULL,NULL,NULL,0,0,0,NULL,NULL,NULL,1,now());
END IF; 

-- ------------------TRANSLATION-------------------------------------------------
IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE objectName = 'masterNames' AND keyName = 'OUTCOME')) THEN 
INSERT INTO `ui_translation` (`objectName`, `keyName`, `defaultValue`, `customerDefineValue`,`afriLanguage`,`vietLanguage`,`lastUpdate`,`lastUpdatedBy`)
VALUES ('masterNames', 'OUTCOME', 'Outcome', 'Outcome','Uitkoms','kết quả',now(),1);
END IF; 

END $$
CALL V20250220222030__Insert_Outcome() $$
DROP PROCEDURE IF EXISTS V20250220222030__Insert_Outcome $$
DELIMITER ;