DELIMITER $$
DROP PROCEDURE IF EXISTS V20250228113516__Alter_Trans_Service_Route $$
CREATE PROCEDURE V20250228113516__Alter_Trans_Service_Route()
BEGIN
IF NOT EXISTS (
        SELECT * 
        FROM information_schema.columns 
        WHERE table_schema = DATABASE() 
          AND table_name = 'trans_service_route' 
          AND column_name = 'transportProviderId'
    ) THEN  
        -- Add the new column
        ALTER TABLE trans_service_route
        ADD COLUMN transportProviderId BIGINT NULL AFTER timeRecordForStops;
        END IF;
IF NOT EXISTS (SELECT * FROM information_schema.referential_constraints WHERE constraint_schema = DATABASE() AND TABLE_NAME = 'trans_service_route' AND CONSTRAINT_NAME = 'fk_trans_service_route_provider') THEN
    ALTER TABLE trans_service_route
    ADD CONSTRAINT fk_trans_service_route_provider FOREIGN KEY (transportProviderId) REFERENCES transport_provider_name(id);
END IF;
END $$
CALL V20250228113516__Alter_Trans_Service_Route() $$
DROP PROCEDURE IF EXISTS V20250228113516__Alter_Trans_Service_Route $$
DELIMITER ;