DELIMITER $$

DROP PROCEDURE IF EXISTS fetchSponsorToBePushInXero $$

CREATE PROCEDURE fetchSponsorToBePushInXero()
BEGIN
    -- Fetch sponsors and their first sponsor_contact based on lowest ID
    SELECT 
        func_inc_var_session_rec() AS id,
        sp.id AS sponsorId,
        sp.sponsorshipCode AS sponsorshipCode, 
        sp.sponsorName AS sponsorName, 
        spal.academyLocationId AS academyLocationId, 
        rc.primaryeEmailId AS emailId, 
        rc.cellCountryCode AS cellCountryCode, 
        rc.cellNo AS cellNo
    FROM sponsors AS sp
    JOIN sponsor_academy_location AS spal
        ON spal.sponsorId = sp.id
    JOIN (
        -- Subquery to get the first sponsor_contact per sponsor
        SELECT 
            spcontact.sponsorId,
            ad.primaryeEmailId, 
            ad.cellCountryCode, 
            ad.cellNo
        FROM sponsor_contacts AS spcontact
        JOIN address AS ad ON ad.id = spcontact.addressId
        WHERE spcontact.id = (
            -- Select the first sponsor_contact (lowest ID) for each sponsor
            SELECT MIN(id) FROM sponsor_contacts 
            WHERE sponsorId = spcontact.sponsorId
        )
    ) AS rc
        ON sp.id = rc.sponsorId
    LEFT JOIN xero_user_mapping AS xum
        ON xum.academiaSponsorId = sp.id 
        AND spal.academyLocationId = xum.academyLocationId
    WHERE xum.id IS NULL;
END $$

DELIMITER ;
