DELIMITER $$
DROP PROCEDURE IF EXISTS V20250414110058__Alter_OrganizationFeePlanMap_main $$
CREATE PROCEDURE V20250414110058__Alter_OrganizationFeePlanMap_main()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.columns WHERE table_schema=DATABASE() AND 
table_name='organizations' AND column_name='whetherFeePlanMappingAtPeriodLevel')) THEN 
Alter table organizations
add column whetherFeePlanMappingAtPeriodLevel bit(1) default null;
END IF;

IF NOT EXISTS ((SELECT * FROM information_schema.columns WHERE table_schema=DATABASE() AND 
table_name='fee_plan_acad_locations' AND column_name='progBatchPeriodConfigId')) THEN 
Alter table fee_plan_acad_locations
add column progBatchPeriodConfigId bigint null default null
after progBatchSeatConfigId;
END IF;

IF EXISTS (
    SELECT * 
    FROM information_schema.columns 
    WHERE table_schema = DATABASE() 
      AND table_name = 'fee_plan_acad_locations' 
      AND column_name = 'progBatchPeriodConfigId'
) THEN
    IF NOT EXISTS (
        SELECT * 
        FROM information_schema.table_constraints 
        WHERE table_schema = DATABASE()
          AND table_name = 'fee_plan_acad_locations'
          AND constraint_name = 'FK_ProgBatchPeriodConfFeePlanMapping'
          AND constraint_type = 'FOREIGN KEY'
    ) THEN
        ALTER TABLE fee_plan_acad_locations
        ADD CONSTRAINT FK_ProgBatchPeriodConfFeePlanMapping
        FOREIGN KEY (progBatchPeriodConfigId) REFERENCES prog_batch_period_config(id);
    END IF;
END IF;

END $$
CALL V20250414110058__Alter_OrganizationFeePlanMap_main() $$
DROP PROCEDURE IF EXISTS V20250414110058__Alter_OrganizationFeePlanMap_main $$
DELIMITER ;