DELIMITER $$
DROP PROCEDURE IF EXISTS V20250414170812__Create_batchStudentSpecialization $$
CREATE PROCEDURE V20250414170812__Create_batchStudentSpecialization()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Columns WHERE table_schema=DATABASE() AND TABLE_NAME = 'batch_student_specialization')) THEN 
CREATE TABLE `batch_student_specialization` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `batchId` bigint NOT NULL,
  `studentSpecializationId` bigint NOT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `lastUpdatedBy` bigint NOT NULL,
  PRIMARY KEY (`id`),
  KEY `fk_batch_student_specialization_batchId` (`batchId`),
  KEY `fk_batch_student_specialization_studentClassificationId` (`studentSpecializationId`),
  CONSTRAINT `fk_batch_student_specialization_studentClassificationId` FOREIGN KEY (`studentSpecializationId`) REFERENCES `student_specialization_csm` (`id`),
  CONSTRAINT `fk_batch_student_specialization_batchId` FOREIGN KEY (`batchId`) REFERENCES `batches` (`id`)
) ;
END IF; 

END $$
CALL V20250414170812__Create_batchStudentSpecialization () $$ 
DROP PROCEDURE IF EXISTS V20250414170812__Create_batchStudentSpecialization $$ 
DELIMITER ;