DELIMITER $$
DROP PROCEDURE IF EXISTS V20250429173808__Create_d2l_oauth_details $$
CREATE PROCEDURE V20250429173808__Create_d2l_oauth_details()
BEGIN
IF EXISTS (SELECT 1 FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='d2l_oauth_details') THEN 
drop table  d2l_oauth_details;
END IF; 
IF NOT EXISTS (SELECT 1 FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='d2l_oauth_details') THEN 
CREATE TABLE d2l_oauth_details (
  id bigint NOT NULL AUTO_INCREMENT,
  tokenFor varchar(10),
  accessToken text NOT NULL,
  expiresIn INT,
  scope text,
  refreshToken text NOT NULL,
  tokenGenrationTime datetime NOT NULL,
  lastUpdatedBy bigint NOT NULL,
  lastUpdate timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (id),
  CONSTRAINT fk_d2lOauthDetails_lastUpdatedBy FOREIGN KEY (lastUpdatedBy) REFERENCES users (id));
END IF; 

END $$
CALL V20250429173808__Create_d2l_oauth_details () $$ 
DROP PROCEDURE IF EXISTS V20250429173808__Create_d2l_oauth_details $$ 
DELIMITER ;